/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.datasources.generators;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.datasources.generators.Generator;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DsLocal")
public class JiraConfluenceLocal
implements Generator {
    private static final Logger log = LoggerFactory.getLogger(JiraConfluenceLocal.class);
    @Inject
    private Crypto mCrypto;
    @Inject
    private ConnectorsFactory connectorsFactory;
    private static final List<String> PRODUCTS = Arrays.asList("jira", "confluence");

    @Override
    public boolean match(DatasourceModel ds) {
        return PRODUCTS.contains(ds.getProduct()) && "direct".equals(ds.getType());
    }

    @Override
    public DatasourceModel generateDS(DatasourceModel dsDef, List<DatasourceModel> datasources, DsOptionsModel options, Object req, Object res) throws Exception {
        String id = dsDef.getId() != null ? dsDef.getId() : UUID.randomUUID().toString();
        DatasourceModel newDs = new DatasourceModel();
        newDs.setId(id);
        newDs.setName(dsDef.getName().trim());
        newDs.setType("direct");
        newDs.setUrl(dsDef.getUrl());
        newDs.setFirst(dsDef.getFirst());
        newDs.setProduct(dsDef.getProduct());
        newDs.setCreator(dsDef.getCreator());
        newDs.setPrivate(dsDef.getPrivate());
        newDs.setCreated(DateTime.now((DateTimeZone)DateTimeZone.UTC).toDate());
        DsOptionsModel tokenData = new DsOptionsModel();
        tokenData.addOtherConfig("id", id);
        tokenData.addOtherConfig("url", newDs.getUrl());
        tokenData.addOtherConfig("type", newDs.getType());
        tokenData.addOtherConfig("product", newDs.getProduct());
        tokenData.addOtherConfig(dsDef.getType(), true);
        ObjectMapper mapper = new ObjectMapper();
        String token = this.mCrypto.encryptBackend(mapper.writeValueAsString((Object)tokenData));
        newDs.setToken(token);
        this.validate(newDs, datasources);
        return newDs;
    }

    public void validate(DatasourceModel dsDef, List<DatasourceModel> datasources) {
        boolean alreadyExists = datasources.stream().anyMatch(ds -> ds.getName().equalsIgnoreCase(dsDef.getName()));
        if (alreadyExists) {
            throw new RuntimeException("CONFLICT");
        }
        try {
            log.debug("DATASOURCE CREATION - BEFORE GET CONNECTOR");
            log.debug("DATASOURCE DATA---------------------------");
            log.debug("-----url:", (Object)dsDef.getUrl());
            log.debug("-----type:", (Object)dsDef.getType());
            log.debug("-----token:", (Object)dsDef.getToken());
            log.debug("-----creator:", (Object)dsDef.getCreator());
            log.debug("-----product:", (Object)dsDef.getProduct());
            DHConnector connector = this.connectorsFactory.getConnector(dsDef);
            log.debug("DATASOURCE CREATION - AFTER GET CONNECTOR", (Object)connector.getURL());
            if (!connector.isValid()) {
                log.error(String.format("Invalid datasource -> %s // %s", dsDef.getProduct(), dsDef.getType()));
                throw new RuntimeException("INVALID_INSTANCE");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("INVALID_INSTANCE", e);
        }
    }
}

