/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.roninpixels.dashboardhub.config.frontedModel.AppConfigModel;
import com.roninpixels.dashboardhub.controllers.AccessManagementController;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.store.DHPermissionsRepository;
import com.roninpixels.dashboardhub.utils.permissions.RestrictionsUtil;
import com.roninpixels.dashboardhub.web.models.PermissionModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Service;

@Service
public class AccessManagementControllerImpl
implements AccessManagementController {
    @Inject
    @ComponentImport
    private PluginSettingsFactory pluginSettingsFactory;
    @Inject
    @ComponentImport
    private TransactionTemplate transactionTemplate;
    @Inject
    private DHPermissionsRepository permissionsRepo;
    @Inject
    private DHUserService userService;
    private ObjectMapper mapper = new ObjectMapper();

    static List<PermissionModel> getPermissionsFrom(AppConfigModel config) {
        Map<String, List<String>> groupAndUsers = RestrictionsUtil.breakDownUserGroups(config.getAppAllowedUserGroups());
        return groupAndUsers.entrySet().parallelStream().flatMap(entry -> ((List)entry.getValue()).stream().map(holderId -> {
            String holderType = ((String)entry.getKey()).contains("user") ? "user" : "group";
            PermissionModel permission = new PermissionModel();
            permission.setHolderId((String)holderId);
            permission.setHolderType(holderType);
            permission.setPermission(99);
            permission.setTargetId("app");
            permission.setTargetType("plugin");
            return permission;
        })).collect(Collectors.toList());
    }

    @Override
    public AppConfigModel updateConfig(final AppConfigModel newConfig) {
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                PluginSettings pluginSettings = AccessManagementControllerImpl.this.pluginSettingsFactory.createGlobalSettings();
                pluginSettings.put("com.roninpixels.dashboardhub:access.management.appRestricted", (Object)newConfig.getAppRestricted().toString());
                pluginSettings.put("com.roninpixels.dashboardhub:access.management.customerPortal", (Object)newConfig.getCustomerPortal().toString());
                List<String> usersGroups = newConfig.getAppAllowedUserGroups();
                if (!newConfig.getAppRestricted().booleanValue() || usersGroups == null || usersGroups.isEmpty()) {
                    AccessManagementControllerImpl.this.permissionsRepo.deletePermissions((Integer)99, "app");
                } else if (usersGroups != null && !usersGroups.isEmpty()) {
                    AccessManagementControllerImpl.this.permissionsRepo.deletePermissions((Integer)99, "app");
                    List<PermissionModel> permissions = AccessManagementControllerImpl.getPermissionsFrom(newConfig);
                    AccessManagementControllerImpl.this.permissionsRepo.createPermissions(permissions);
                }
                return null;
            }
        });
        return this.getConfig();
    }

    @Override
    public AppConfigModel getConfig() {
        return (AppConfigModel)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                PluginSettings settings = AccessManagementControllerImpl.this.pluginSettingsFactory.createGlobalSettings();
                AppConfigModel config = new AppConfigModel();
                String appRestrictedStr = (String)settings.get("com.roninpixels.dashboardhub:access.management.appRestricted");
                config.setAppRestricted(appRestrictedStr != null && Boolean.parseBoolean(appRestrictedStr));
                config.setCustomerPortal(AccessManagementControllerImpl.this.isCustomerPortalEnabled(settings));
                List<PermissionModel> storedPermissions = AccessManagementControllerImpl.this.permissionsRepo.getPermissions(99);
                List<String> groupsAndUsers = storedPermissions.stream().map(p -> String.format("%sId:%s", p.getHolderType(), p.getHolderId())).collect(Collectors.toList());
                config.setAppAllowedUserGroups(groupsAndUsers);
                return config;
            }
        });
    }

    @Override
    public AppConfigModel getConfig(boolean includeIsRestricted) {
        AppConfigModel appConfig = this.getConfig();
        if (includeIsRestricted) {
            appConfig.setRestrictedAccess(!this.canLoggedInUserAccess());
        }
        return appConfig;
    }

    @Override
    public boolean canUserAccess(String userKey) {
        if (userKey == null) {
            return false;
        }
        HashMap<String, List<String>> queryData = new HashMap<String, List<String>>();
        queryData.put("user", Arrays.asList(userKey));
        ArrayList<String> groupNames = new ArrayList<String>(this.userService.getGroupNamesFor(userKey));
        queryData.put("group", groupNames);
        List<PermissionModel> permissions = this.permissionsRepo.getPermissions((Integer)99, queryData);
        return !permissions.isEmpty();
    }

    @Override
    public boolean canLoggedInUserAccess() {
        AppConfigModel appConfig = this.getConfig();
        String userKey = this.userService.getLoggedInUserKey();
        return userKey != null && (appConfig.getAppRestricted() == false || this.canUserAccess(userKey));
    }

    @Override
    public boolean isCustomerPortalEnabled() {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        return this.isCustomerPortalEnabled(settings);
    }

    private boolean isCustomerPortalEnabled(PluginSettings settings) {
        String customerPortalEnabledStr = (String)settings.get("com.roninpixels.dashboardhub:access.management.customerPortal");
        return customerPortalEnabledStr != null && Boolean.parseBoolean(customerPortalEnabledStr);
    }
}

