/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers;

import com.roninpixels.dashboardhub.gadgetsValidators.GadgetValidator;
import com.roninpixels.dashboardhub.gadgetsValidators.ValidationResponse;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class GadgetsValidationController {
    @Inject
    private ApplicationContext context;

    public ValidationResponse validateDataFor(BoardModel board) {
        ValidationResponse response = new ValidationResponse(true);
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(this.validateBoard(board));
        if (errors.isEmpty()) {
            board.getData().stream().forEach(slide -> slide.stream().forEach(gadget -> {
                ValidationResponse validation = this.validateGadget((GadgetModel)gadget);
                errors.addAll(validation.getErrors());
            }));
        }
        if (!errors.isEmpty()) {
            response.setValid(false);
            response.getErrors().addAll(errors);
        }
        return response;
    }

    public ValidationResponse validateDataFor(GadgetModel gadget) {
        return this.validateGadget(gadget);
    }

    private GadgetValidator getGadgetValidator(GadgetModel gadget) {
        String widget = gadget.getWidget() + "Validator";
        if (!this.context.containsBean(widget)) {
            return null;
        }
        return (GadgetValidator)this.context.getBean(widget, GadgetValidator.class);
    }

    private ValidationResponse validateGadget(GadgetModel gadget) {
        GadgetValidator validator = this.getGadgetValidator(gadget);
        if (validator != null) {
            return validator.validateData(gadget);
        }
        return new ValidationResponse(true);
    }

    private List<String> validateBoard(BoardModel board) {
        return Collections.emptyList();
    }
}

