/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions;

import com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions.BitbucketDatacenterBaseFunc;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class GetPullRequestsFunc
extends BitbucketDatacenterBaseFunc {
    private static final Logger log = LoggerFactory.getLogger(GetPullRequestsFunc.class);
    public static final String PATH_PATTERN = "/rest/api/1.0/projects/%s/repos/%s/pull-requests";

    public GetPullRequestsFunc(ServerConnector serverConnector) {
        super(serverConnector);
    }

    public ResponseEntity<List> exec(String projectKey, String repoSlug, Map<String, String> params, boolean loadAll) {
        String path = String.format(PATH_PATTERN, projectKey, repoSlug);
        List prs = this.getData(path, params, 1000, loadAll);
        prs.stream().forEach(pr -> {
            pr.put("repo_slug", repoSlug);
            pr.put("project", projectKey);
        });
        return new ResponseEntity((Object)prs, HttpStatus.OK);
    }
}

