/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.dashboardfilters.controllers.impl;

import com.atlassian.activeobjects.tx.Transactional;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.controllers.DashboardFilterRulesController;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.controllers.DashboardFilterRulesListenerController;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.web.models.DashboardFilterRule;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.web.models.Group;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.web.models.Page;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.web.models.User;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class DashboardFilterRulesListenerControllerImpl
implements DashboardFilterRulesListenerController {
    @Inject
    private DashboardFilterRulesController dashboardFilterRulesController;

    @Override
    public void handleRemovalOfGroup(Group group) {
        List<DashboardFilterRule> dashboardFilterRules = this.dashboardFilterRulesController.getDashboardFilterRules();
        if (dashboardFilterRules == null) {
            return;
        }
        for (DashboardFilterRule filterRule : dashboardFilterRules) {
            if (filterRule.getUsersAndGroupsRestricted() == null || !filterRule.getUsersAndGroupsRestricted().contains(group.getName())) continue;
            filterRule.getUsersAndGroupsRestricted().remove(group.getName());
        }
        this.dashboardFilterRulesController.setDashboardFilterRules(dashboardFilterRules);
    }

    @Override
    public void handleRemovalOfUser(User user) {
        List<DashboardFilterRule> dashboardFilterRules = this.dashboardFilterRulesController.getDashboardFilterRules();
        if (dashboardFilterRules == null) {
            return;
        }
        for (DashboardFilterRule filterRule : dashboardFilterRules) {
            if (filterRule.getUsersAndGroupsRestricted() == null || !filterRule.getUsersAndGroupsRestricted().contains(user.getName())) continue;
            filterRule.getUsersAndGroupsRestricted().remove(user.getName());
        }
        this.dashboardFilterRulesController.setDashboardFilterRules(dashboardFilterRules);
    }

    @Override
    public void handleRemovalOfPage(Page page) {
        List<DashboardFilterRule> dashboardFilterRules = this.dashboardFilterRulesController.getDashboardFilterRules();
        if (dashboardFilterRules == null) {
            return;
        }
        for (DashboardFilterRule filterRule : dashboardFilterRules) {
            if (filterRule.getWikiPageId() == null || filterRule.getWikiPageId() != page.getId()) continue;
            filterRule.setWikiPageId(null);
            filterRule.setDashboardLocation(DashboardFilterRule.DashboardLocation.GLOBAL_DASHBOARD);
        }
        this.dashboardFilterRulesController.setDashboardFilterRules(dashboardFilterRules);
    }
}

