/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.dashboardHub.boards.userPreferences;

import com.roninpixels.dashboardhub.controllers.BoardUserPreferencesController;
import com.roninpixels.dashboardhub.web.models.BoardUserPreferenceModel;
import com.roninpixels.dashboardhub.web.rest.dashboardHub.boards.userPreferences.BoardUserPreferenceMessageModel;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/boardUserPreferences")
public class BoardUserPreferencesEndpoint {
    private static final Logger log = LoggerFactory.getLogger(BoardUserPreferencesEndpoint.class);
    @Inject
    private BoardUserPreferencesController boardUserPreferencesController;

    @GET
    @Path(value="/{boardId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getBoardUserPreferences(@NotNull @PathParam(value="boardId") String boardId) {
        try {
            BoardUserPreferenceModel boardUserPreference = this.boardUserPreferencesController.getBoardUserPreference(boardId);
            if (boardUserPreference == null) {
                boardUserPreference = this.boardUserPreferencesController.createOrUpdateBoardUserPreference(boardId, "{}");
            }
            return Response.ok((Object)new BoardUserPreferenceMessageModel(boardUserPreference.getBoardId(), boardUserPreference.getFilter())).build();
        }
        catch (Exception e) {
            log.error("Problems getting a boardUserPreference with boardId -> " + boardId, (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setBoardUserPreferences(BoardUserPreferenceMessageModel message) {
        try {
            BoardUserPreferenceModel newBoardUserPreference = this.boardUserPreferencesController.createOrUpdateBoardUserPreference(message.getBoardId(), message.getFilter());
            return Response.ok((Object)new BoardUserPreferenceMessageModel(newBoardUserPreference.getBoardId(), newBoardUserPreference.getFilter())).build();
        }
        catch (Exception e) {
            log.error("Problems creating or updating a boardUserPreference with boardId -> " + message.getBoardId(), (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

