/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.exceptions.GadgetBadConfigException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.CycleLeadTimeConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.EpicProgress;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.ReportingEntityType;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CycleLeadTime
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(EpicProgress.class);
    static final String FIELD_ASSIGNEE = "assignee";
    static final String FIELD_PROJECT = "project";
    static final String FIELD_SPRINT = "sprint";
    static final String FIELD_EPIC_LINK = "Epic Link";
    static final List<String> DEFAULT_ISSUE_FIELDS = Arrays.asList("status", "id", "created", "issuetype");
    static final List<String> EXPAND_VALUE = Arrays.asList("changelog");

    String getJQL(CycleLeadTimeConfig config, List<String> extraParams) {
        String jql;
        switch (config.getReportingEntityType()) {
            case assignees: {
                List<String> assignees = config.getAssignees();
                if (assignees == null || assignees.isEmpty()) {
                    throw new GadgetBadConfigException("Assignees can not be empty");
                }
                jql = String.format("%s in ('%s')", FIELD_ASSIGNEE, assignees.stream().collect(Collectors.joining("','")));
                break;
            }
            case epics: {
                List<String> epics = config.getEpics();
                if (epics == null || epics.isEmpty()) {
                    throw new GadgetBadConfigException("Epics can not be empty");
                }
                jql = String.format("'%s' in (%s)", FIELD_EPIC_LINK, epics.stream().collect(Collectors.joining(",")));
                break;
            }
            case customJQL: {
                jql = config.getFilter().getJql();
                break;
            }
            case projects: {
                List<String> projects = config.getProjects();
                if (projects == null || projects.isEmpty()) {
                    throw new GadgetBadConfigException("Projects can not be empty");
                }
                jql = String.format("%s in (%s)", FIELD_PROJECT, projects.stream().collect(Collectors.joining(",")));
                break;
            }
            default: {
                throw new RuntimeException("ReportingEntityType not supported: " + (Object)((Object)config.getReportingEntityType()));
            }
        }
        return jql;
    }

    String getAggregationField(CycleLeadTimeConfig config, List<String> extraParams) {
        String fieldKey;
        switch (config.getReportingEntityType()) {
            case assignees: {
                fieldKey = FIELD_ASSIGNEE;
                break;
            }
            case epics: {
                fieldKey = extraParams != null && extraParams.size() > 2 ? extraParams.get(2) : FIELD_EPIC_LINK;
                break;
            }
            case projects: {
                fieldKey = FIELD_PROJECT;
                break;
            }
            case sprints: {
                fieldKey = extraParams != null && extraParams.size() > 1 ? extraParams.get(1) : FIELD_SPRINT;
                break;
            }
            case customJQL: {
                fieldKey = null;
                break;
            }
            default: {
                throw new RuntimeException("ReportingEntityType not supported: " + (Object)((Object)config.getReportingEntityType()));
            }
        }
        return fieldKey;
    }

    String getExcludeIssueTypeJQL(CycleLeadTimeConfig config) {
        String jqlExcludedIssueType = "";
        List<String> excludedIssueTypes = config.getExcludedIssueTypes();
        if (!ReportingEntityType.customJQL.equals((Object)config.getReportingEntityType()) && excludedIssueTypes != null && !excludedIssueTypes.isEmpty()) {
            jqlExcludedIssueType = String.format(" AND issueType not in (%s)", excludedIssueTypes.stream().map(type -> type.contains(" ") ? String.format("'%s'", type) : type).collect(Collectors.joining(",")));
        }
        return jqlExcludedIssueType;
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        CycleLeadTimeConfig config = GadgetRequesterUtils.getConfig(gadget, CycleLeadTimeConfig.class);
        String jqlBase = this.getJQL(config, extraParams);
        String jqlExcludedIssueType = this.getExcludeIssueTypeJQL(config);
        String jql = jqlBase + jqlExcludedIssueType;
        String aggregationField = this.getAggregationField(config, extraParams);
        ArrayList<String> fields = new ArrayList<String>(DEFAULT_ISSUE_FIELDS);
        if (aggregationField != null) {
            fields.add(aggregationField);
        }
        List issues = super.execJQLwithFilterFields(jql, fields, EXPAND_VALUE, null, null, null);
        HashMap<String, Object> responseObj = new HashMap<String, Object>();
        responseObj.put("aggregationField", aggregationField);
        responseObj.put("issues", issues);
        return responseObj;
    }
}

