/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.dashboardHub.dashboardGadgets;

import com.roninpixels.dashboardhub.controllers.DashboardGadgetsController;
import com.roninpixels.dashboardhub.gadgetsValidators.GadgetValidatorException;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.web.models.DashboardGadgetMessageModel;
import com.roninpixels.dashboardhub.web.models.DashboardGadgetModel;
import com.roninpixels.dashboardhub.web.rest.MessagesUtil;
import java.util.HashMap;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/gadget")
public class DashboardGadgetsEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardGadgetsEndpoint.class);
    @Inject
    private DashboardGadgetsController dashboardGadgetsController;
    @Inject
    private DHUserService userService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addDashboardGadget(DashboardGadgetMessageModel message) {
        try {
            DashboardGadgetModel existingDashboardGadget;
            DashboardGadgetModel dashboardGadget = this.parseGadgetMessage(message);
            DashboardGadgetModel newDashboardGadget = null;
            newDashboardGadget = message.getContainerData().isMacro() ? (message.getContainerData().getItemId().equals("0") ? this.dashboardGadgetsController.addDashboardGadget(dashboardGadget, true) : this.dashboardGadgetsController.updateDashboardGadget(dashboardGadget)) : ((existingDashboardGadget = this.dashboardGadgetsController.getDashboardGadget(dashboardGadget.getContainerId(), dashboardGadget.getItemId())) == null ? this.dashboardGadgetsController.addDashboardGadget(dashboardGadget) : this.dashboardGadgetsController.updateDashboardGadget(dashboardGadget));
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRAP_ROOT_VALUE});
            return Response.ok((Object)mapper.writeValueAsString((Object)newDashboardGadget)).build();
        }
        catch (GadgetValidatorException ge) {
            return MessagesUtil.generateValidationErrorResponse();
        }
        catch (Exception e) {
            LOGGER.error("Problems creating a dashboard gadget", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    private DashboardGadgetModel parseGadgetMessage(DashboardGadgetMessageModel message) {
        DashboardGadgetModel dashboardGadget = message.getGadgetData();
        dashboardGadget.setContainerId(message.getContainerData().getContainerId());
        dashboardGadget.setItemId(message.getContainerData().getItemId());
        String userKey = this.userService.getLoggedInUserKey();
        dashboardGadget.setOwner(userKey);
        return dashboardGadget;
    }

    @DELETE
    @Path(value="/{containerId}/{itemId}")
    @Produces(value={"application/json"})
    public Response deleteDashboardGadget(@NotNull @PathParam(value="containerId") String containerId, @NotNull @PathParam(value="itemId") String itemId) {
        try {
            boolean removed = this.dashboardGadgetsController.removeDashboardGadget(containerId, itemId);
            HashMap<String, String> msg = new HashMap<String, String>();
            if (removed) {
                msg.put("status", "ok");
            } else {
                msg.put("error", "The dashboard gadget couldn't be deleted");
            }
            ObjectMapper mapper = new ObjectMapper();
            return Response.ok((Object)mapper.writeValueAsString(msg)).build();
        }
        catch (Exception e) {
            LOGGER.error("Problems deleting the dashboard gadget - containerId -> " + containerId + " itemId " + itemId, (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/{containerId}/id/{itemId}")
    @Produces(value={"application/json"})
    public Response getDashboardGadget(@NotNull @PathParam(value="containerId") String containerId, @NotNull @PathParam(value="itemId") String itemId) {
        DashboardGadgetModel existingDashboardGadget = this.dashboardGadgetsController.getDashboardGadget(containerId, itemId);
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRAP_ROOT_VALUE});
        return Response.ok((Object)existingDashboardGadget).build();
    }
}

