/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.confluence.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.ConfluenceConnector;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/confluence/v2/cql")
public class CQLv2Endpoint {
    private static final Logger log = LoggerFactory.getLogger(CQLv2Endpoint.class);
    private static final String[] expand = new String[]{"space", "container", "metadata.labels", "history", "history.lastUpdated", "history.lastUpdated.collaborators", "history.lastUpdated.collaborators.users"};
    @Inject
    private ConnectorsProvider connProvider;

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response getSpaces(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @NotNull @QueryParam(value="cql") String cql) {
        try {
            ConfluenceConnector confluence = (ConfluenceConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("cql", cql);
            params.put("expand", String.join((CharSequence)",", expand));
            params.put("limit", 100);
            params.put("type", "page");
            List content = confluence.execCQL(params, Collections.emptyMap());
            String link = confluence.getURL().split("/wiki")[0];
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("content", content);
            data.put("link", link);
            return Response.ok(data).build();
        }
        catch (Exception e) {
            log.error("Problems getting boards", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

