/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket;

import com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket.BitbucketGadgetRequesterBase;
import com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket.configBeans.GRWithReposConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class LastFailedPipeline
extends BitbucketGadgetRequesterBase {
    private static final Logger log = LoggerFactory.getLogger(LastFailedPipeline.class);
    private static final String PAGE_SIZE = "50";
    static final String FAILED_STATE = "pipeline_state_completed_failed";
    static final String FAILED_STEP_STATE = "pipeline_step_state_completed_failed";
    static final String NO_PROJECT = null;

    Map findFailedPipeline(List<Map> pipelines) {
        return pipelines.stream().filter(pl -> {
            try {
                Object resultType = ((Map)((Map)pl.get("state")).get("result")).get("type");
                return FAILED_STATE.equals(resultType);
            }
            catch (Exception e) {
                return false;
            }
        }).findFirst().orElse(null);
    }

    Map getLastFailedPipeline(String repo) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pagelen", PAGE_SIZE);
        params.put("sort", "-created_on");
        Map lastFailedPipeline = null;
        int page = 1;
        boolean hasMore = true;
        while (hasMore) {
            params.put("page", "" + page++);
            ResponseEntity<List> res = this.connector.getPipelines(repo, params);
            this.checkStatus(res);
            List pipelines = (List)res.getBody();
            lastFailedPipeline = this.findFailedPipeline(pipelines);
            hasMore = lastFailedPipeline == null && !pipelines.isEmpty();
        }
        if (lastFailedPipeline != null) {
            lastFailedPipeline.put("slug", repo);
        }
        return lastFailedPipeline;
    }

    Map getLastFailedPipeline(List<String> repos) {
        return repos.parallelStream().map(repo -> this.getLastFailedPipeline((String)repo)).filter(Objects::nonNull).sorted(PIPELINE_COMPARATOR.reversed()).findFirst().orElse(null);
    }

    Map getCommitData(Map pipeline) {
        Map commit = this.findCommit(pipeline);
        if (commit != null) {
            String slug = (String)pipeline.get("slug");
            String hash = (String)commit.get("hash");
            ResponseEntity<Map> res = this.connector.getCommit(NO_PROJECT, slug, hash);
            this.checkStatus(res);
            return (Map)res.getBody();
        }
        return null;
    }

    List getStepsData(Map pipeline) {
        String slug = (String)pipeline.get("slug");
        String uuid = (String)pipeline.get("uuid");
        ResponseEntity<List> res = this.connector.getPipelineSteps(slug, uuid, Collections.emptyMap());
        this.checkStatus(res);
        this.populateStepFailedLog(slug, uuid, (List)res.getBody());
        return (List)res.getBody();
    }

    private void populateStepFailedLog(String slug, String uuid, List<Map> stepsList) {
        for (Map stepMap : stepsList) {
            Map state = (Map)stepMap.get("state");
            Map result = (Map)(state.get("result") != null ? state.get("result") : state.get("stage"));
            String type = (String)result.get("type");
            if (!type.equals(FAILED_STATE) && !type.equals(FAILED_STEP_STATE)) continue;
            ResponseEntity<String> resLog = this.connector.getPipelineStepLog(slug, uuid, String.valueOf(stepMap.get("uuid")));
            stepMap.put("log", resLog.getBody());
        }
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        GRWithReposConfig config = GadgetRequesterUtils.getConfig(gadget, GRWithReposConfig.class);
        Map pipeline = this.getLastFailedPipeline(config.getRepositoriesSlugs());
        if (pipeline != null) {
            pipeline.put("commitData", this.getCommitData(pipeline));
            pipeline.put("stepsData", this.getStepsData(pipeline));
        }
        HashMap<String, Map> data = new HashMap<String, Map>();
        data.put("pipeline", pipeline);
        return data;
    }
}

