/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.atlassianInsight;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.atlassianInsight.AtlassianInsightGadgetRequesterBase;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class IQLSearch
extends AtlassianInsightGadgetRequesterBase {
    private static final Logger log = LoggerFactory.getLogger(IQLSearch.class);

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        String iql = (String)gadget.getConfig().getOtherConfig().getOrDefault("iql", "");
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("iql", iql);
            ResponseEntity<Map> response = this.connector.searchByIQL(params);
            this.checkStatus(response);
            return response.getBody();
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

