/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers;

import com.roninpixels.dashboardhub.controllers.ResponseMessage;
import com.roninpixels.dashboardhub.store.UserPropertiesRepository;
import com.roninpixels.dashboardhub.web.models.PropertyModel;
import java.io.IOException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserPropertiesController {
    private static final Logger log = LoggerFactory.getLogger(UserPropertiesController.class);
    @Inject
    private UserPropertiesRepository repo;

    public ResponseMessage createOrUpdate(String propertyKey, Object value) {
        return this.createOrUpdate(null, propertyKey, value);
    }

    public ResponseMessage createOrUpdate(String userKey, String propertyKey, Object value) {
        try {
            PropertyModel pModel = new PropertyModel(propertyKey, value);
            if (this.repo.updateUserProperty(userKey, pModel)) {
                return ResponseMessage.UPDATED;
            }
            if (this.repo.addUserProperty(pModel)) {
                return ResponseMessage.CREATED;
            }
        }
        catch (Exception e) {
            log.error("Problems adding a user property: " + propertyKey, (Throwable)e);
        }
        return ResponseMessage.ERROR;
    }

    public PropertyModel get(String key) throws IOException {
        return this.repo.getUserProperty(key, PropertyModel.class);
    }

    public PropertyModel get(String user, String key) throws IOException {
        return this.repo.getUserProperty(user, key, PropertyModel.class);
    }

    public ResponseMessage delete(String propertyKey) {
        return this.repo.removeUserProperty(propertyKey) ? ResponseMessage.DELETED : ResponseMessage.ERROR;
    }

    public ResponseMessage delete(String userKey, String propertyKey) {
        return this.repo.removeUserProperty(userKey, propertyKey) ? ResponseMessage.DELETED : ResponseMessage.ERROR;
    }
}

