/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.factories;

import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.OpsgenieTokenAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.connectors.factories.ConnectorFactory;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnectorConfiguration;
import com.roninpixels.dashboardhub.connectors.impl.opsgenie.OpsgenieConnectorImpl;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.RestAuthStrategyFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.ServerConnectorFactory;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class OpsgenieRestConnectorFactory
implements ConnectorFactory {
    public static final String URL_BASE_UE = "https://api.eu.opsgenie.com";
    public static final String URL_BASE_DEFAULT = "https://api.opsgenie.com";
    @Inject
    private ServerConnectorFactory serverConnectorFactory;
    @Inject
    private RestAuthStrategyFactory authStrategyFactory;
    @Inject
    private Crypto crypto;

    @Override
    public DHConnector createConnector(DatasourceModel ds) {
        RestAuthStrategy strategy = this.authStrategyFactory.getRestAuthStrategy(OpsgenieTokenAuthStrategy.class, ds);
        return new OpsgenieConnectorImpl(this.serverConnectorFactory.getServerConnector(ds, strategy, this.getConnectorConfig(ds)));
    }

    @Override
    public boolean match(DatasourceModel ds) {
        return ds.getProduct().equals("opsgenie");
    }

    private ServerConnectorConfiguration getConnectorConfig(DatasourceModel ds) {
        ServerConnectorConfiguration config = new ServerConnectorConfiguration();
        config.setUrlBaseForAPIs(this.selectURLBaseFrom(ds));
        return config;
    }

    private String selectURLBaseFrom(DatasourceModel ds) {
        DsOptionsModel options = DatasourcesUtil.getOptions(this.crypto, ds.getToken());
        return options != null && options.getOption("isEu", Boolean.class) != false ? URL_BASE_UE : URL_BASE_DEFAULT;
    }
}

