/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.JSMMultiproject;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.JSMDataUtil2;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.configs.CustomerSatisfactionConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerSatisfaction
extends JSMMultiproject {
    private static final Logger log = LoggerFactory.getLogger(CustomerSatisfaction.class);

    protected List getIssues(String dateFrom, String queuesJql, String feedbackFieldName, List<String> fieldNames) {
        String jql = String.format("%s != NULL AND updatedDate >= '%s' AND (%s)", feedbackFieldName, dateFrom, queuesJql);
        return this.execJQLwithFilterFields(jql, fieldNames, null, null, null, null);
    }

    protected List getPreviousIssues(String dateFrom, String dateFromPrevious, String queuesJql, String feedbackFieldName, List<String> fieldNames) {
        String jql = String.format("%s != NULL AND updatedDate < '%s' AND updatedDate >= '%s' AND (%s)", feedbackFieldName, dateFrom, dateFromPrevious, queuesJql);
        return this.execJQLwithFilterFields(jql, fieldNames, null, null, null, null);
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        CustomerSatisfactionConfig config = GadgetRequesterUtils.getConfig(gadget, CustomerSatisfactionConfig.class);
        try {
            Map jqlQueuesMap = this.getJqlQueues(config);
            String dateFrom = JSMDataUtil2.getDateAsString(config.getTimeRange());
            String feedbackFieldName = config.getFeedbackField().get(1);
            List issues = this.getIssues(dateFrom, (String)jqlQueuesMap.get("jql"), feedbackFieldName, Arrays.asList(config.getFeedbackField().get(0), config.getFeedbackDateField().get(0)));
            String dateFromPrevious = JSMDataUtil2.getPreviousDateAsString(config.getTimeRange(), 2);
            List previousIssues = this.getPreviousIssues(dateFrom, dateFromPrevious, (String)jqlQueuesMap.get("jql"), feedbackFieldName, Arrays.asList(config.getFeedbackField().get(0), config.getFeedbackDateField().get(0)));
            HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
            data.put("issues", issues);
            data.put("previousIssues", previousIssues);
            data.put("queues", (List<Object>)jqlQueuesMap.get("queues"));
            return data;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems getting data", e);
        }
    }
}

