/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.confluence;

import com.roninpixels.dashboardhub.gadgetsRequesters.confluence.ConfluenceBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.confluence.PopularPagesConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopularPages
extends ConfluenceBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(PopularPages.class);
    private static int CONF_DAYS = 7;
    private static int DEFAULT_MAX_RESULTS = 10;

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        PopularPagesConfig config = GadgetRequesterUtils.getConfig(gadget, PopularPagesConfig.class);
        Integer maxResults = config.getMaxResults();
        if (maxResults == null || maxResults < 1 && 100 < maxResults) {
            log.warn(String.format("Max results not valid for getting popular pages: %s. Setting default size: %s", maxResults, DEFAULT_MAX_RESULTS));
            maxResults = DEFAULT_MAX_RESULTS;
        }
        List<Map> pages = this.confluenceConnector.getPopularPages(maxResults, CONF_DAYS);
        return pages;
    }
}

