/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.genericServer;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.roninpixels.dashboardhub.app.RequestFactoryWrapper;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnectorConfiguration;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class ServerConnector {
    public static final int CONNECTION_TIMEOUT = 30000;
    public static final int SOCKET_TIMEOUT = 60000;
    private static final Logger log = LoggerFactory.getLogger(ServerConnector.class);
    @Inject
    private RequestFactoryWrapper requestFactoryWrapper;
    private RestAuthStrategy authStrategy;
    private DatasourceModel datasource;
    private ServerConnectorConfiguration config = new ServerConnectorConfiguration();

    public void init(DatasourceModel datasource, RestAuthStrategy authStrategy) {
        this.init(datasource, authStrategy, null);
    }

    public void init(DatasourceModel datasource, RestAuthStrategy authStrategy, ServerConnectorConfiguration config) {
        this.datasource = datasource;
        this.authStrategy = authStrategy;
        if (config != null) {
            this.config = config;
        }
    }

    public String getURL() {
        return this.config.getUrlBaseForAPIs() == null ? this.datasource.getUrl() : this.config.getUrlBaseForAPIs();
    }

    public boolean isCloud() {
        return this.datasource.getType().equals("cloud");
    }

    public <T> T getProperty(String propName, Class<T> clazz) {
        return this.config.getProperty(propName, clazz);
    }

    public void applyAuthenticationStrategy(Request request, UriComponentsBuilder builder) {
        this.authStrategy.applyAuthenticationStrategy(request, builder);
    }

    private <T> ResponseEntity<T> executeRequest(Request request, final Class<T> clazz) throws Exception {
        request.setConnectionTimeout(30000);
        request.setSoTimeout(60000);
        return (ResponseEntity)request.executeAndReturn(new ReturningResponseHandler(){

            public Object handle(Response response) throws ResponseException {
                block4: {
                    ServerConnector.this.authStrategy.analyzeHeaders(response);
                    if (InputStream.class == clazz) {
                        LinkedMultiValueMap headers = new LinkedMultiValueMap();
                        headers.put((Object)"Content-Type", Arrays.asList((String)response.getHeaders().get("content-type")));
                        return new ResponseEntity((Object)response.getResponseBodyAsStream(), (MultiValueMap)headers, HttpStatus.valueOf((int)response.getStatusCode()));
                    }
                    if (String.class != clazz) {
                        ObjectMapper mapper = new ObjectMapper();
                        try {
                            return new ResponseEntity(mapper.readValue(response.getResponseBodyAsString(), clazz), HttpStatus.valueOf((int)response.getStatusCode()));
                        }
                        catch (IOException e) {
                            if (response.getStatusCode() >= 400) break block4;
                            throw new RuntimeException(e);
                        }
                    }
                }
                return new ResponseEntity((Object)response.getResponseBodyAsString(), HttpStatus.valueOf((int)response.getStatusCode()));
            }
        });
    }

    public <T> ResponseEntity<T> executeRequest(Request.MethodType method, String path, Map<String, ?> params, Class<T> clazz) {
        return this.executeRequest(method, path, params, Collections.emptyMap(), clazz);
    }

    public <T> ResponseEntity<T> executeRequest(Request.MethodType method, String path, Map<String, ?> params, Map<String, String> headers, String paramBody, Class<T> clazz) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(path.startsWith("http") ? path : this.getURL() + path));
        String body = paramBody;
        try {
            if (method == Request.MethodType.GET || method == Request.MethodType.POST && body != null) {
                if (params != null) {
                    LinkedMultiValueMap p = new LinkedMultiValueMap();
                    for (String key : params.keySet()) {
                        Object value = params.get(key);
                        List<String> actualValue = value instanceof List ? (List<String>)value : Arrays.asList(value.toString());
                        log.debug(key + " -> " + value + " -> " + actualValue);
                        p.put((Object)key, actualValue);
                    }
                    builder.queryParams((MultiValueMap)p);
                }
            } else if (method == Request.MethodType.POST && paramBody == null) {
                ObjectMapper mapper = new ObjectMapper();
                body = mapper.writeValueAsString(params);
                log.debug("post body -> " + builder.toUriString() + " // " + body);
            } else {
                throw new UnsupportedOperationException(String.format("Method not supported for ", builder.toUriString(), method));
            }
            Request request = this.requestFactoryWrapper.createRequest(method, builder.toUriString());
            this.applyAuthenticationStrategy(request, builder);
            request.setHeader("Accept", MediaType.APPLICATION_JSON.toString());
            if (headers != null && !headers.isEmpty()) {
                headers.entrySet().stream().forEach(entry -> request.setHeader((String)entry.getKey(), (String)entry.getValue()));
            }
            if (body != null) {
                request.setRequestBody(body, MediaType.APPLICATION_JSON.toString());
            }
            log.debug(method + " path -> " + builder.toUriString());
            return this.executeRequest(request, clazz);
        }
        catch (UnsupportedOperationException uoe) {
            throw uoe;
        }
        catch (Exception e) {
            log.error("Problems with the request: " + builder.toUriString(), (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public <T> ResponseEntity<T> executeRequest(Request.MethodType method, String path, Map<String, ?> params, Map<String, String> headers, Class<T> clazz) {
        return this.executeRequest(method, path, params, headers, null, clazz);
    }

    public <T> ResponseEntity<T> executeRequest(String path, Map<String, ?> params, Class<T> clazz) {
        return this.executeRequest(Request.MethodType.GET, path, params, clazz);
    }

    public ResponseEntity<String> executeRequest(String path, Map<String, ?> params) {
        return this.executeRequest(path, params, String.class);
    }

    public ResponseEntity<String> executeRequest(String path) {
        return this.executeRequest(path, null);
    }
}

