/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.atlassianInsight.functions;

import com.roninpixels.dashboardhub.connectors.impl.atlassianInsight.functions.IQLResponse;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.opsgenie.functions.GetOpsGenieDataFunc;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class SearchByIQLFunc {
    private static final Logger log = LoggerFactory.getLogger(GetOpsGenieDataFunc.class);
    private static final int MAX_ELEMENTS = 1001;
    public static final String PATH = "/aql/objects";
    private final ServerConnector connector;

    public SearchByIQLFunc(ServerConnector serverConnector) {
        this.connector = serverConnector;
    }

    public ResponseEntity<Map> exec(Map<String, String> params) {
        HashMap<String, String> mParams = params == null ? new HashMap<String, String>() : new HashMap<String, String>(params);
        mParams.putIfAbsent("resultPerPage", "50");
        mParams.putIfAbsent("qlQuery", params.get("iql"));
        LinkedList<Map> objectEntries = new LinkedList<Map>();
        LinkedList<Map> objectTypeAttributes = new LinkedList<Map>();
        int page = 1;
        boolean hasMore = true;
        while (hasMore) {
            mParams.put("page", "" + page++);
            ResponseEntity<IQLResponse> responseEntity = this.connector.executeRequest(PATH, mParams, IQLResponse.class);
            if (responseEntity.getStatusCode().value() >= 400) {
                throw new BadRequestToSourceException(responseEntity);
            }
            IQLResponse result = (IQLResponse)responseEntity.getBody();
            objectEntries.addAll(result.getObjectEntries());
            objectTypeAttributes.addAll(result.getObjectTypeAttributes());
            hasMore = result.getPageNumber() < result.getPageSize() && objectEntries.size() < 1001;
        }
        HashMap<String, LinkedList<Map>> data = new HashMap<String, LinkedList<Map>>();
        data.put("objectEntries", objectEntries);
        data.put("objectTypeAttributes", objectTypeAttributes);
        return new ResponseEntity(data, HttpStatus.OK);
    }
}

