/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.dashboardHub.gadgetsRequester;

import com.roninpixels.dashboardhub.controllers.GadgetsRequesterController;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequesterException;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.GadgetRequestModel;
import com.roninpixels.dashboardhub.services.DashboardHubPluginManager;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GadgetsRequestEndpointService {
    private static final Logger log = LoggerFactory.getLogger(GadgetsRequestEndpointService.class);
    @Inject
    private GadgetsRequesterController controller;
    @Inject
    private DashboardHubPluginManager dhLicenseManager;

    public Response doRequest(GadgetRequestModel gadgetRequest) {
        try {
            GadgetModel gadget = this.controller.findGadgetWithDatasource(gadgetRequest);
            return this.doRequest(gadget, gadgetRequest.getExtraParams(), Collections.emptyMap());
        }
        catch (GadgetRequesterException gre) {
            log.error("Problems with gadget request", (Throwable)gre);
            return Response.status((int)gre.getCode()).entity(this.createErrorMessage(gre)).build();
        }
    }

    public Response doRequest(GadgetModel gadget, List<String> extraParams, Map context) {
        try {
            if (!this.dhLicenseManager.isLicensed()) {
                throw new GadgetRequesterException("License is not valid", 400);
            }
            Object data = this.controller.getDataFor(gadget, gadget.getConfig().getDatasource(), extraParams, context);
            return Response.ok((Object)data).build();
        }
        catch (BadRequestToSourceException bre) {
            log.error("Request problems for a gadget request");
            Object entity = bre.getBody() != null ? bre.getBody() : bre.getResponseEntity().getBody();
            return Response.status((int)bre.getStatusCode()).entity(entity).build();
        }
        catch (GadgetRequesterException gre) {
            log.error("Problems with gadget request", (Throwable)gre);
            return Response.status((int)gre.getCode()).entity(this.createErrorMessage(gre)).build();
        }
        catch (Exception e) {
            log.error("Problems with gadget request", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    Map<String, String> createErrorMessage(GadgetRequesterException gre) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("error", gre.getMessage());
        return response;
    }
}

