/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.JSMMultiproject;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.JSMDataUtil2;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.configs.SLAAccomplishmentConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDataUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLAAccomplishment
extends JSMMultiproject {
    private static final Logger log = LoggerFactory.getLogger(SLAAccomplishment.class);

    protected List<Field> getMatchingFields(SLAAccomplishmentConfig config) throws Exception {
        List fields = this.getFields();
        String fieldId = config.getSlaField().get(0);
        return JiraDataUtils.getFieldsWithSameName(fieldId, fields);
    }

    protected List getIssues(SLAAccomplishmentConfig config, String queryJql) throws Exception {
        List<Field> matchingFields = this.getMatchingFields(config);
        String fieldsSubQuery = JSMDataUtil2.getMatchingFieldsSubQuery(matchingFields);
        String jql = String.format("(%s) AND %s", fieldsSubQuery, queryJql);
        List<String> fields = JSMDataUtil2.getKeysOrIds(matchingFields);
        fields.add("priority");
        return this.execJQLwithFilterFields(jql, fields, null, null, null, null);
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        SLAAccomplishmentConfig config = GadgetRequesterUtils.getConfig(gadget, SLAAccomplishmentConfig.class);
        try {
            Map jqlQueuesMap = this.getJqlQueues(config);
            List issues = this.getIssues(config, (String)jqlQueuesMap.get("jql"));
            HashMap<String, List> data = new HashMap<String, List>();
            data.put("issues", issues);
            return data;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems getting data", e);
        }
    }
}

