/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.ImageProvider;
import com.roninpixels.dashboardhub.store.DHDatasourcesRepository;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ImageController {
    private static final Logger log = LoggerFactory.getLogger(ImageController.class);
    @Autowired
    private DHDatasourcesRepository dsRepo;
    @Autowired
    private ConnectorsFactory connectorsFactory;

    public ResponseEntity<InputStream> getImage(String datasourceId, String route) throws Exception {
        DatasourceModel ds = this.dsRepo.getDatasource(datasourceId);
        DHConnector dhConnector = this.connectorsFactory.getConnector(ds);
        if (!(dhConnector instanceof ImageProvider)) {
            log.error("Get image not implemented for " + ds.getProduct());
            throw new UnsupportedOperationException("Get image not implemented for " + ds.getProduct());
        }
        ResponseEntity<InputStream> imageInputStream = ((ImageProvider)((Object)dhConnector)).getImage(route);
        return imageInputStream;
    }
}

