/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.exceptions.GadgetBadConfigException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.AgileGadgetReponseData;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.agileProviders.AgileIssuesProvider;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.configs.AgileGadgetConfig;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprintBurndown
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(SprintBurndown.class);
    private static final List<String> DEFAULT_FIELDS = Arrays.asList("status", "id", "created", "issuetype");
    static final List<String> COMPATIBLE_REPORTING_TYPE = Collections.unmodifiableList(Arrays.asList("boards", "sprints"));

    @Override
    protected List<String> getCompatibleReportingTypes() {
        return COMPATIBLE_REPORTING_TYPE;
    }

    AgileIssuesProvider getProvider(AgileGadgetConfig config) {
        AgileIssuesProvider provider = this.getAgileIssuesProvider(config.getReportingEntityType());
        provider.setStaticConfig(DEFAULT_FIELDS);
        return provider;
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        AgileGadgetConfig config = GadgetRequesterUtils.getConfig(gadget, AgileGadgetConfig.class);
        if (config.getReportingEntityType() == null) {
            config.setReportingEntityType("boards");
        }
        if ("boards".equals(config.getReportingEntityType())) {
            config.setnElements(1);
            config.setSprintFilter(Arrays.asList("active"));
        }
        if (config.getSprints().size() + config.getAllBoards().size() > 1) {
            throw new GadgetBadConfigException("Bad configuration: too many sprints or boards: " + gadget.getName());
        }
        AgileIssuesProvider provider = this.getProvider(config);
        AgileGadgetReponseData data = provider.getAgileData(config, extraParams);
        return data;
    }
}

