/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.dashboardHub;

import com.atlassian.plugins.rest.common.interceptor.InterceptorChain;
import com.roninpixels.dashboardhub.controllers.UserPreferencesController;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.web.models.UserPreferencesModel;
import com.roninpixels.dashboardhub.web.rest.ValidatorInterceptor;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
@Path(value="/user/preferences")
public class UserPreferencesEndpoint {
    private static final Logger log = LoggerFactory.getLogger(UserPreferencesEndpoint.class);
    @Inject
    private DHUserService dhUserService;
    @Inject
    private UserPreferencesController userPreferencesCtr;

    @GET
    @Produces(value={"application/json"})
    public Response getUserPreferences() {
        String userKey = this.dhUserService.getLoggedInUserKey();
        UserPreferencesModel prefs = this.userPreferencesCtr.getUserPreference(userKey);
        return Response.ok((Object)prefs).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @InterceptorChain(value={ValidatorInterceptor.class})
    public Response setUserPreferences(@Valid UserPreferencesModel prefs) {
        String userKey = this.dhUserService.getLoggedInUserKey();
        try {
            UserPreferencesModel savedPrefs = this.userPreferencesCtr.createOrUpdateUserPreference(userKey, prefs);
            return Response.ok((Object)savedPrefs).build();
        }
        catch (Exception e) {
            log.error("Problems saving the preferences of a user - " + userKey, (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

