/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers;

import com.roninpixels.dashboardhub.ao.AddonProperty;
import com.roninpixels.dashboardhub.controllers.ResponseMessage;
import com.roninpixels.dashboardhub.store.AddonPropertiesRepository;
import com.roninpixels.dashboardhub.web.models.PropertyModel;
import java.io.IOException;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Service;

@Service
public class AddonPropertiesController {
    @Inject
    private AddonPropertiesRepository repo;
    private ObjectMapper objectMapper = new ObjectMapper();

    private PropertyModel deserialize(String json) throws IOException {
        return (PropertyModel)this.objectMapper.readValue(json, PropertyModel.class);
    }

    private String serialize(String key, Object value) throws IOException {
        PropertyModel prop = new PropertyModel(key, value);
        return this.objectMapper.writeValueAsString((Object)prop);
    }

    public ResponseMessage createOrUpdate(String key, Object value) throws IOException {
        String json = this.serialize(key, value);
        if (this.repo.update(key, json) != null) {
            return ResponseMessage.UPDATED;
        }
        if (this.repo.create(key, json) != null) {
            return ResponseMessage.CREATED;
        }
        return ResponseMessage.ERROR;
    }

    public PropertyModel get(String key) throws IOException {
        AddonProperty propertyStored = this.repo.get(key);
        return propertyStored == null ? null : this.deserialize(propertyStored.getValue());
    }

    public ResponseMessage delete(String key) {
        return this.repo.remove(key) != null ? ResponseMessage.DELETED : ResponseMessage.ERROR;
    }
}

