/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.common;

import com.sun.jersey.api.NotFoundException;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResponseErrorHandler;

@Component
public class JiraRestResponseErrorHandler
implements ResponseErrorHandler {
    public boolean hasError(ClientHttpResponse httpResponse) throws IOException {
        return httpResponse.getStatusCode().series() == HttpStatus.Series.SERVER_ERROR;
    }

    public void handleError(ClientHttpResponse httpResponse) throws IOException {
        if (httpResponse.getStatusCode().series() == HttpStatus.Series.SERVER_ERROR) {
            throw new HttpServerErrorException(httpResponse.getStatusCode(), httpResponse.getStatusText());
        }
        if (httpResponse.getStatusCode().series() == HttpStatus.Series.CLIENT_ERROR && httpResponse.getStatusCode() == HttpStatus.NOT_FOUND) {
            throw new NotFoundException();
        }
    }
}

