/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions;

import com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions.BitbucketDatacenterBaseFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions.GetCommitFunc;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class GetPrInfoFunc
extends BitbucketDatacenterBaseFunc {
    private static final Logger log = LoggerFactory.getLogger(GetPrInfoFunc.class);
    public static final String PATH_PR_INFO = "/rest/api/1.0/projects/%s/repos/%s/pull-requests/%s?avatarSize=128";

    public GetPrInfoFunc(ServerConnector serverConnector) {
        super(serverConnector);
    }

    Map getPullRequest(Map pullRequest) {
        String repoSlug = (String)pullRequest.get("repo_slug");
        Integer repoId = (Integer)pullRequest.get("id");
        String project = (String)pullRequest.get("project");
        String path = String.format(PATH_PR_INFO, project, repoSlug, repoId);
        ResponseEntity<Map> response = this.connector.executeRequest(path, Collections.emptyMap(), Map.class);
        this.checkStatus(response);
        return (Map)response.getBody();
    }

    Map getCommit(Map pullRequest) {
        String repoSlug = (String)pullRequest.get("repo_slug");
        String hash = (String)((Map)pullRequest.get("fromRef")).get("latestCommit");
        String project = (String)pullRequest.get("project");
        ResponseEntity<Map> response = new GetCommitFunc(this.connector).exec(project, repoSlug, hash);
        return (Map)response.getBody();
    }

    public ResponseEntity<Map> exec(Map pullRequest, List<String> expand) {
        Map prData = this.getPullRequest(pullRequest);
        if (expand.contains("commit")) {
            Map commitData = this.getCommit(pullRequest);
            prData.put("commit", commitData);
        }
        return new ResponseEntity((Object)prData, HttpStatus.OK);
    }
}

