/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class GetInlineTasksCloudFunc {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetInlineTasksCloudFunc.class);
    public static final String REST_INLINETASKS_REPORT = "/rest/api/inlinetasks/search";
    public static final String EXTRACT_USER_ID_PATTERN = "<ac:link><ri:user (ri:account-id=\"([0-9a-z:-]+)\"|ri:accountId=\"([0-9a-z:-]+)\") \\/><\\/ac:link>";
    public static final String EXTRACT_USER_ID_FROM_BODY_PATTERN = "<ac:link><ri:user (ri:account-id=\"([0-9a-z:-]+)\"|ri:user-name=\"([0-9a-z:-]+)\"|ri:accountId=\"([0-9a-z:-]+)\"|ri:username=\"([0-9a-z:-]+)\") \\/><\\/ac:link>";
    public static final String EXTRACT_DATE_PATTERN = "<time datetime=\"([0-9]{4}-[0-9]{2}-[0-9]{2})\" \\/>";
    private final ServerConnector connector;

    public GetInlineTasksCloudFunc(ServerConnector connector) {
        this.connector = connector;
    }

    public static final Map getInlineUsersTaskMap(List<Map> tasks) {
        LinkedHashMap<String, List<String>> inlineUsersTaskMap = new LinkedHashMap<String, List<String>>();
        for (Map task : tasks) {
            String body = task.getOrDefault("body", "");
            String contentId = String.valueOf(task.get("contentId"));
            String taskId = String.valueOf(task.get("id"));
            String globalId = String.valueOf(task.get("globalId"));
            List<String> inlineUsersIds = GetInlineTasksCloudFunc.getTaskUserIds(body);
            inlineUsersTaskMap.put(taskId + "-" + globalId + "-" + contentId, inlineUsersIds);
        }
        return inlineUsersTaskMap;
    }

    public static final List<String> getTasksContentIds(List<Map> tasks) {
        ArrayList<String> contentIds = new ArrayList<String>();
        for (Map task : tasks) {
            String contentId = String.valueOf(task.get("contentId"));
            contentIds.add(contentId);
        }
        return contentIds;
    }

    public static List<String> getTaskUserIds(String body) {
        ArrayList<String> userIds = new ArrayList<String>();
        String userRegex = EXTRACT_USER_ID_PATTERN;
        Pattern pattern = Pattern.compile(userRegex, 10);
        Matcher matcher = pattern.matcher(body);
        while (matcher.find()) {
            String userId = matcher.group(2);
            if (userId == null || userIds.contains(userId)) continue;
            userIds.add(userId);
        }
        return userIds;
    }

    public static final List<String> getTaskUsernames(Map task) {
        ArrayList<String> usernames = new ArrayList<String>();
        if (task.containsKey("assignee") && !usernames.contains((String)task.get("assignee"))) {
            usernames.add((String)task.get("assignee"));
        }
        List<String> inlineUserIds = GetInlineTasksCloudFunc.getTaskUserIds((String)task.get("body"));
        for (String id : inlineUserIds) {
            if (id == null || usernames.contains(id)) continue;
            usernames.add(id);
        }
        return usernames;
    }

    public static final List<Map> formatTasks(List<Map> tasks, Map inlineUsersTaskMap, Map userMap, List<Map> contents) {
        return tasks.stream().map(task -> {
            LinkedHashMap formattedTask = new LinkedHashMap();
            formattedTask.put("taskId", task.get("id"));
            formattedTask.put("contentId", task.get("contentId"));
            formattedTask.put("path", task.get("path"));
            Map contentMap = contents != null ? (Map)contents.stream().filter(content -> content.get("id").equals(task.get("contentId"))).findFirst().orElse(null) : null;
            formattedTask.put("title", contentMap != null ? contentMap.get("title") : task.get("contentId"));
            formattedTask.put("body", GetInlineTasksCloudFunc.parseTaskBody((String)task.get("body"), userMap));
            String inlineKey = task.get("id") + "-" + task.get("globalId") + "-" + task.get("contentId");
            if (inlineUsersTaskMap.containsKey(inlineKey)) {
                List inlineUsersIds = (List)inlineUsersTaskMap.get(inlineKey);
                formattedTask.put("assignees", inlineUsersIds.stream().map(inlineUserId -> userMap.get(inlineUserId)).filter(user -> user != null).collect(Collectors.toList()));
            }
            return formattedTask;
        }).collect(Collectors.toList());
    }

    static final String parseTaskBody(String str, Map userMap) {
        String SEPARATOR_STRING = "##DASHBOARDS_SEPARATOR##";
        String strCopy = str;
        String userRegex = EXTRACT_USER_ID_FROM_BODY_PATTERN;
        Pattern userPattern = Pattern.compile(userRegex, 10);
        Matcher userMatcher = userPattern.matcher(str);
        while (userMatcher.find()) {
            String userId = userMatcher.group(2);
            if (userId == null) continue;
            if (!userMap.containsKey(userId)) {
                strCopy = strCopy.replace(userMatcher.group(0), "<span class=\"pending-task-bold\">" + userId + " (Unlicensed user)</span>");
                continue;
            }
            Map user = (Map)userMap.get(userId);
            String displayName = (String)user.get("displayName");
            strCopy = strCopy.replace(userMatcher.group(0), "<span class=\"pending-task-bold\">" + displayName + "</span>");
        }
        String dateRegex = EXTRACT_DATE_PATTERN;
        Pattern datePattern = Pattern.compile(dateRegex, 10);
        Matcher dateMatcher = datePattern.matcher(strCopy);
        while (dateMatcher.find()) {
            String dateMatch = dateMatcher.group(1);
            if (dateMatch == null) continue;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat finalSimpleDateFormat = new SimpleDateFormat("EEE, MMM d");
            try {
                Date newDate = simpleDateFormat.parse(dateMatch);
                String formattedDate = finalSimpleDateFormat.format(newDate);
                strCopy = strCopy.replace(dateMatcher.group(0), "<span class=\"pending-task-date\">" + formattedDate + "</span>");
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        strCopy = strCopy.replace("<ac:link ", SEPARATOR_STRING + "<ac:link ");
        strCopy = strCopy.replace("</ac:link>", "</ac:link>" + SEPARATOR_STRING);
        strCopy = String.join((CharSequence)"", strCopy.split(SEPARATOR_STRING));
        strCopy = strCopy.replaceAll("<ac:link ", "<span class=\"pending-task-bold\" ").replaceAll("</ac:link>", "</span>");
        return strCopy;
    }

    public List<Map> getData(Map params) throws IOException {
        int start = params.getOrDefault("start", 0);
        int limit = params.getOrDefault("limit", 30);
        List spaces = params.containsKey("spaces") ? (List)params.get("spaces") : Arrays.asList(new Object[0]);
        String status = params.containsKey("status") ? (String)params.get("status") : null;
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        reportParams.put("start", start);
        reportParams.put("limit", limit);
        if (!spaces.isEmpty()) {
            reportParams.put("spaceKey", spaces.stream().collect(Collectors.joining(",")));
        }
        if (status != null) {
            reportParams.put("status", status);
        }
        reportParams.remove("spaces");
        ArrayList<Map> fullTasks = new ArrayList<Map>();
        boolean hasMore = true;
        while (hasMore) {
            ResponseEntity<Map> responseEntity = this.connector.executeRequest(REST_INLINETASKS_REPORT, reportParams, Map.class);
            ResponseChecker.checkStatus(responseEntity);
            Map result = (Map)responseEntity.getBody();
            List tasks = (List)result.get("results");
            fullTasks.addAll(tasks);
            int next = (Integer)result.get("start") + limit;
            hasMore = spaces.size() >= limit && fullTasks.size() < 300;
            if (!hasMore) continue;
            reportParams.put("start", next);
            reportParams.put("limit", limit);
        }
        return fullTasks;
    }
}

