/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.dashboardfilters.controllers.impl;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.ResponseException;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.controllers.DashboardFilterRulesController;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.controllers.DashboardFilterRulesFileController;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.web.models.DashboardFilterRule;
import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DashboardFilterRulesFileControllerImpl
implements DashboardFilterRulesFileController {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardFilterRulesFileControllerImpl.class);
    private final XStream xStream = new XStream();
    @Inject
    private RequestFactory requestFactory;
    @Inject
    private DashboardFilterRulesController dashboardFilterRulesController;

    @Override
    public String getDashboardFilterRulesAsXml() {
        List<DashboardFilterRule> filterRules = this.dashboardFilterRulesController.getDashboardFilterRules();
        return this.xStream.toXML(filterRules);
    }

    @Override
    public List<DashboardFilterRule> getDashboardFilterRulesFromXml(String xml) {
        try {
            return (List)this.xStream.fromXML(xml);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public InputStream getInputStreamFromUrl(String url) throws ResponseException {
        Request request = this.requestFactory.createRequest(Request.MethodType.GET, url);
        InputStream[] responseInputStream = new InputStream[1];
        request.execute(response -> {
            if (response.getStatusCode() != 200) {
                LOG.error("The following status code was returned when trying to get input stream from URL " + url + " - " + response.getStatusCode());
            }
            responseInputStream[0] = response.getResponseBodyAsStream();
        });
        return responseInputStream[0];
    }

    @Override
    public String getJsonFromUrl(String url) throws ResponseException {
        return this.getJsonFromUrl(url, null, null);
    }

    @Override
    public String getJsonFromUrl(String url, String username, String password) throws ResponseException {
        Request request = this.requestFactory.createRequest(Request.MethodType.GET, url);
        request.setHeader("Accept", "application/json");
        if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
            request.setHeader("Authorization", "Basic " + new String(new Base64().encode((username + ":" + password).getBytes())).replaceAll("\n", ""));
        }
        String[] responseString = new String[1];
        request.execute(response -> {
            if (response.getStatusCode() != 200) {
                LOG.error("The following status code was returned when trying to get JSON from URL " + url + " - " + response.getStatusCode());
            }
            responseString[0] = response.getResponseBodyAsString();
        });
        return responseString[0];
    }
}

