/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.servlet;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.roninpixels.dashboardhub.config.action.DHAction;
import com.roninpixels.dashboardhub.config.action.DHShowAction;
import com.roninpixels.dashboardhub.utils.TokenGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHForbiddenServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DHForbiddenServlet.class);
    private static final String RESOURCE = "resources";
    private static final String TEMPLATE_PATH = "/templates/dashboard-hub-main.vm";
    @Inject
    @ComponentImport
    private TemplateRenderer templateRenderer;
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private Provider<DHShowAction> actionsProvider;
    private String resources;

    public void init() {
        this.resources = this.getServletConfig().getInitParameter(RESOURCE);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("resp", resp);
        context.put("urlMode", req.getContextPath());
        context.put("scope", Collections.singletonList(this.resources));
        DHAction action = this.getAction(req);
        context.put("action", action);
        resp.setHeader("Content-Type", "text/html");
        this.templateRenderer.render(this.getTemplatePath(), context, (Writer)resp.getWriter());
    }

    protected String getTemplatePath() {
        return TEMPLATE_PATH;
    }

    protected DHAction getAction(HttpServletRequest req) {
        DHShowAction action = (DHShowAction)this.actionsProvider.get();
        return action;
    }
}

