/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.confluence.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.ConfluenceConnector;
import com.roninpixels.dashboardhub.web.rest.jira.api.GenericJiraEndpoint;
import java.util.HashMap;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/confluence/v1/spaces")
public class SpaceEndpoint {
    private static final Logger log = LoggerFactory.getLogger(SpaceEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response getSpaces(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            ConfluenceConnector confluence = (ConfluenceConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("all", true);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("status", "current");
            return GenericJiraEndpoint.generateResponse(confluence.getSpaces(params, options));
        }
        catch (Exception e) {
            log.error("Problems getting boards", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

