/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.bitbucket.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.BitbucketConnector;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/bitbucket/v1/pullrequests")
public class PullRequestsEndpoint {
    private static final Logger log = LoggerFactory.getLogger(PullRequestsEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    List<String> splitParam(String param) {
        return param == null ? Collections.emptyList() : Arrays.asList(param.split(",")).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    List<Map> getRepos(BitbucketConnector connector, List<String> reposList) {
        return reposList.parallelStream().map(slug -> (List)connector.getPullRequests(null, (String)slug, Collections.emptyMap(), true).getBody()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    List<Map> getExtendedPrs(BitbucketConnector connector, List<Map> prs, List<String> expandList) {
        return prs.parallelStream().map(pullRequest -> (Map)connector.getPrInfo((Map)pullRequest, expandList).getBody()).collect(Collectors.toList());
    }

    List<Map> getData(BitbucketConnector connector, String repos, String expand) {
        List<String> expandList = this.splitParam(expand);
        List<String> reposList = this.splitParam(repos);
        List<Map> prs = this.getRepos(connector, reposList);
        List<Map> extendedPrs = this.getExtendedPrs(connector, prs, expandList);
        return extendedPrs;
    }

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response getPullRequests(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @QueryParam(value="repositories") String repositories, @QueryParam(value="expand") String expand) {
        try {
            BitbucketConnector connector = (BitbucketConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            List<Map> data = this.getData(connector, repositories, expand);
            return Response.status((int)200).entity(data).build();
        }
        catch (Exception e) {
            log.error("Problems getting pull requests from Bitbucket", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

