/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.store.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.roninpixels.dashboardhub.ao.DHBoard;
import com.roninpixels.dashboardhub.store.DHBoardsRepository;
import com.roninpixels.dashboardhub.web.models.EncryptedBoardModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DHBoardsRepositoryImpl
implements DHBoardsRepository {
    private static final Logger log = LoggerFactory.getLogger(DHBoardsRepositoryImpl.class);
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private final ObjectMapper mMapper;

    @Inject
    public DHBoardsRepositoryImpl(ActiveObjects ao, TransactionTemplate transactionTemplate) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
        this.mMapper = new ObjectMapper();
    }

    @Override
    public List<String> getGlobalBoardsKeys() {
        DHBoard[] boards = this.findGlobalBoards();
        return Arrays.stream(boards).map(board -> board.getKey()).collect(Collectors.toList());
    }

    @Override
    public List<String> getPrivateBoardsKeysForUser(String userKey) {
        DHBoard[] boards = this.findPrivateBoardsFor(userKey);
        return Arrays.stream(boards).map(board -> board.getKey()).collect(Collectors.toList());
    }

    @Override
    public List<EncryptedBoardModel> getAllBoards() {
        DHBoard[] boards = this.findGlobalBoards();
        return this.transform(boards);
    }

    @Override
    public List<EncryptedBoardModel> getAllPrivateBoards() {
        DHBoard[] boards = this.findPrivateBoards();
        return this.transform(boards);
    }

    @Override
    public List<String> getAllBoardKeys() {
        DHBoard[] boards = this.findGlobalBoards();
        return this.getIds(boards);
    }

    @Override
    public List<EncryptedBoardModel> getPrivateBoards(String userKey) {
        DHBoard[] boards = this.findPrivateBoardsFor(userKey);
        return this.transform(boards);
    }

    @Override
    public List<String> getAllBoardKeys(String userKey) {
        DHBoard[] boards = this.findBoardsFor(userKey);
        return this.getIds(boards);
    }

    @Override
    public EncryptedBoardModel getBoard(String boardKey) {
        DHBoard board = this.findBoard(boardKey);
        return board != null ? this.transform(board) : null;
    }

    @Override
    public EncryptedBoardModel addBoard(EncryptedBoardModel newBoard) throws IOException {
        String value = this.mMapper.writeValueAsString((Object)newBoard);
        DHBoard savedBoard = (DHBoard)this.transactionTemplate.execute(() -> {
            boolean isGlobal = this.isGlobal(newBoard);
            DHBoard board = (DHBoard)this.ao.create(DHBoard.class, new DBParam[]{new DBParam("KEY", (Object)newBoard.getId()), new DBParam("OWNER", (Object)newBoard.getOwner()), new DBParam("GLOBAL", (Object)isGlobal), new DBParam("VALUE", (Object)value)});
            board.save();
            log.debug("Board created -> " + board.getKey());
            return board;
        });
        return this.transform(savedBoard);
    }

    @Override
    public EncryptedBoardModel updateBoard(EncryptedBoardModel board) throws IOException {
        String value = this.mMapper.writeValueAsString((Object)board);
        DHBoard updatedBoard = (DHBoard)this.transactionTemplate.execute(() -> {
            DHBoard target = this.findBoard(board.getId());
            if (target != null) {
                target.setGlobal(this.isGlobal(board));
                target.setValue(value);
                target.setOwner(board.getOwner());
                target.save();
                log.debug("Board updated -> " + target.getKey());
            }
            return target;
        });
        return updatedBoard != null ? this.transform(updatedBoard) : null;
    }

    @Override
    public boolean removeBoard(String boardKey) {
        if (boardKey == null) {
            throw new IllegalArgumentException("Board key cannot be null");
        }
        DHBoard deletedBoard = (DHBoard)this.transactionTemplate.execute(() -> {
            DHBoard targetBoard = this.findBoard(boardKey);
            if (targetBoard != null) {
                this.ao.delete(new RawEntity[]{targetBoard});
            }
            return targetBoard;
        });
        return deletedBoard != null;
    }

    private DHBoard findBoard(String key) {
        Query query = Query.select().where("KEY = ?", new Object[]{key});
        DHBoard[] boards = (DHBoard[])this.ao.find(DHBoard.class, query);
        if (boards.length == 0) {
            return null;
        }
        if (boards.length > 1) {
            throw new RuntimeException(String.format("There are more than one board with same key: %s", key));
        }
        return boards[0];
    }

    private List<EncryptedBoardModel> transform(DHBoard[] boards) {
        return Arrays.stream(boards).map(board -> this.transform((DHBoard)board)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private EncryptedBoardModel transform(DHBoard board) {
        try {
            return (EncryptedBoardModel)this.mMapper.readValue(board.getValue(), EncryptedBoardModel.class);
        }
        catch (IOException ioe) {
            log.warn("Stored board invalid!!! -> " + board.getKey());
            return null;
        }
    }

    private DHBoard[] findGlobalBoards() {
        Query query = Query.select().where("GLOBAL = ?", new Object[]{true});
        return (DHBoard[])this.ao.find(DHBoard.class, query);
    }

    private DHBoard[] findPrivateBoards() {
        Query query = Query.select().where("GLOBAL = ?", new Object[]{false});
        return (DHBoard[])this.ao.find(DHBoard.class, query);
    }

    private DHBoard[] findPrivateBoardsFor(String userKey) {
        Query query = Query.select().where("OWNER = ? AND GLOBAL = ?", new Object[]{userKey, false});
        return (DHBoard[])this.ao.find(DHBoard.class, query);
    }

    private DHBoard[] findBoardsFor(String userKey) {
        Query query = Query.select().where("OWNER = ?", new Object[]{userKey});
        return (DHBoard[])this.ao.find(DHBoard.class, query);
    }

    private boolean isGlobal(EncryptedBoardModel board) {
        return board.getGlobal() == null ? false : board.getGlobal();
    }

    private List<String> getIds(DHBoard[] boards) {
        ArrayList<String> ids = new ArrayList<String>(boards.length);
        for (DHBoard board : boards) {
            ids.add(board.getKey());
        }
        return ids;
    }
}

