/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.EpicProgressConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Filter;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JqlUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EpicProgress
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(EpicProgress.class);
    static final String DEFAULT_EPIC_LINK_FIELD_NAME = "Epic Link";
    static final List<String> DEFAULT_EPIC_FIELDS = Arrays.asList("status", "id", "duedate", "summary");
    static final List<String> DEFAULT_ISSUE_FIELDS = Arrays.asList("status", "id");

    protected List getFields() throws Exception {
        String rawResponse = (String)this.jiraConnector.getFields().getBody();
        ObjectMapper mapper = new ObjectMapper();
        return (List)mapper.readValue(rawResponse, (TypeReference)new TypeReference<List<Field>>(){});
    }

    protected Field getEpicLinkField() throws Exception {
        List fieldList = this.getFields();
        return fieldList.stream().filter(field -> DEFAULT_EPIC_LINK_FIELD_NAME.equalsIgnoreCase(field.getName())).findFirst().orElse(null);
    }

    protected String getEpicLinkFieldClauseName() {
        try {
            Field epicLinkField = this.getEpicLinkField();
            List clauseNames = (List)epicLinkField.getOtherFields().get("clauseNames");
            return (String)clauseNames.get(0);
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            return DEFAULT_EPIC_LINK_FIELD_NAME;
        }
    }

    List<Map> getEpics(EpicProgressConfig config, List<String> extraFields) {
        List<String> fields = new LinkedList<String>(DEFAULT_EPIC_FIELDS);
        if (extraFields != null) {
            fields.addAll(extraFields);
        }
        fields = fields.stream().filter(Objects::nonNull).collect(Collectors.toList());
        Filter filter = config.getFilter();
        String partialJql = filter.getJql();
        String jql = JqlUtils.appendToJql(partialJql, "issuetype = Epic", "AND");
        return this.execJQLwithFilterFields(jql, fields, null, null, null, "");
    }

    void populateWithIssues(List<Map> epics, List<String> metric) {
        String epicLinkFieldName = this.getEpicLinkFieldClauseName();
        LinkedList<String> fields = new LinkedList<String>(DEFAULT_ISSUE_FIELDS);
        if (metric != null) {
            fields.addAll(JiraSprintDataUtils.extractFieldsNamesFromMetric(metric));
        }
        epics.parallelStream().forEach(epic -> {
            String key = (String)epic.get("key");
            List issues = this.execJQLwithFilterFields(String.format("\"%s\" = \"%s\" OR parent = \"%s\"", epicLinkFieldName, key, key), fields, null, null, null, null);
            epic.put("issues", issues);
        });
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        EpicProgressConfig config = GadgetRequesterUtils.getConfig(gadget, EpicProgressConfig.class);
        List<Map> epics = this.getEpics(config, extraParams);
        this.populateWithIssues(epics, config.getMetric());
        HashMap<String, List<Map>> responseObj = new HashMap<String, List<Map>>();
        responseObj.put("epics", epics);
        return responseObj;
    }
}

