/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public abstract class BitbucketCloudBaseFunc {
    private static final Logger log = LoggerFactory.getLogger(BitbucketCloudBaseFunc.class);
    protected final ServerConnector connector;

    public BitbucketCloudBaseFunc(ServerConnector serverConnector) {
        this.connector = serverConnector;
    }

    protected ServerConnector getConnector() {
        return this.connector;
    }

    public List getData(String path, Map<String, String> params, int elementsLimit, boolean loadAll) {
        Map<String, String> mParams = params != null ? new HashMap<String, String>(params) : new HashMap();
        mParams.putIfAbsent("pagelen", "50");
        mParams.putIfAbsent("page", "1");
        LinkedList elements = new LinkedList();
        boolean addMore = true;
        while (addMore) {
            ResponseEntity<Map> response = this.getConnector().executeRequest(path, mParams, Map.class);
            this.checkStatus(response);
            Map body = (Map)response.getBody();
            List values = (List)body.get("values");
            elements.addAll(values);
            addMore = loadAll && elements.size() < elementsLimit && body.containsKey("next");
            if (!addMore) continue;
            path = (String)body.get("next");
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("Problems decoding the next path -> " + path, (Throwable)e);
            }
            mParams = Collections.emptyMap();
        }
        return elements;
    }

    public String getData(String path) {
        ResponseEntity<String> response = this.getConnector().executeRequest(path, null, String.class);
        this.checkStatus(response);
        return (String)response.getBody();
    }

    public void checkStatus(ResponseEntity response) {
        int responseCode = response.getStatusCode().value();
        if (responseCode >= 400) {
            throw new BadRequestToSourceException(response);
        }
    }
}

