/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.dashboardfilters.web.models;

import com.roninpixels.dashboardhub.utils.permissions.RestrictionsUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="filterRule")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DashboardFilterRule
implements Serializable {
    private String key;
    private int priority;
    private DashboardLocation dashboardLocation;
    private String wikiPageId;
    private String globalDashboardId;
    private boolean renderedAsDashboardAction;
    private boolean restrictedToAllUsers;
    private List<String> usersAndGroupsRestricted;
    private Date lastModified;

    public DashboardFilterRule() {
    }

    public DashboardFilterRule(String id) {
        this.setKey(id);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public DashboardLocation getDashboardLocation() {
        return this.dashboardLocation;
    }

    public void setDashboardLocation(DashboardLocation dashboardLocation) {
        this.dashboardLocation = dashboardLocation;
    }

    public String getWikiPageId() {
        return this.wikiPageId;
    }

    public void setWikiPageId(String wikiPageId) {
        this.wikiPageId = wikiPageId;
    }

    public String getGlobalDashboardId() {
        return this.globalDashboardId;
    }

    public void setGlobalDashboardId(String globalDashboardId) {
        this.globalDashboardId = globalDashboardId;
    }

    public boolean isRenderedAsDashboardAction() {
        return this.renderedAsDashboardAction;
    }

    public void setRenderedAsDashboardAction(boolean renderedAsDashboardAction) {
        this.renderedAsDashboardAction = renderedAsDashboardAction;
    }

    public boolean isRestrictedToAllUsers() {
        return this.restrictedToAllUsers;
    }

    public void setRestrictedToAllUsers(boolean restrictedToAllUsers) {
        this.restrictedToAllUsers = restrictedToAllUsers;
    }

    public List<String> getUsersAndGroupsRestricted() {
        return this.usersAndGroupsRestricted;
    }

    public void setUsersAndGroupsRestricted(List<String> usersAndGroupsRestricted) {
        this.usersAndGroupsRestricted = usersAndGroupsRestricted;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public List<String> getRestrictedGroups() {
        if (this.getUsersAndGroupsRestricted() != null) {
            Map<String, List<String>> usersAndGroups = RestrictionsUtil.breakDownUserGroups(this.getUsersAndGroupsRestricted());
            return usersAndGroups.get("groups");
        }
        return new ArrayList<String>();
    }

    public List<String> getRestrictedUsers() {
        if (this.getUsersAndGroupsRestricted() != null) {
            Map<String, List<String>> usersAndGroups = RestrictionsUtil.breakDownUserGroups(this.getUsersAndGroupsRestricted());
            return usersAndGroups.get("users");
        }
        return new ArrayList<String>();
    }

    public static enum DashboardLocation {
        GLOBAL_DASHBOARD,
        SITE_HOMEPAGE,
        WIKI_PAGE;

    }
}

