/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.servlet.filter;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.io.IOException;
import java.net.URI;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHServletFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DHServletFilter.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;

    public DHServletFilter(UserManager userManager, LoginUriProvider loginUriProvider) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (!httpRequest.getServletPath().equals("/rest") && httpRequest.getPathInfo().startsWith("/dashboardHub") && !this.canContinue(httpRequest, (HttpServletResponse)response)) {
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean canContinue(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String username;
            UserProfile user = this.userManager.getRemoteUser(request);
            boolean isUserAdmin = user == null ? false : this.userManager.isSystemAdmin(user.getUserKey());
            String string = username = user == null ? null : user.getUsername();
            if (username != null || isUserAdmin) {
                return true;
            }
        }
        catch (Exception e) {
            log.warn("Problems filtering a servlet request", (Throwable)e);
        }
        this.redirectToLogin(request, response);
        return false;
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

