/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.confluence;

import com.roninpixels.dashboardhub.gadgetsRequesters.confluence.ConfluenceBaseGadgetRequester;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQLSearch
extends ConfluenceBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(CQLSearch.class);
    private static final String[] expand = new String[]{"space", "container", "metadata.labels", "history", "history.lastUpdated", "history.lastUpdated.collaborators", "history.lastUpdated.collaborators.users"};

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        String cql = (String)gadget.getConfig().getOtherConfig().get("cql");
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("cql", cql);
            params.put("expand", String.join((CharSequence)",", expand));
            List content = this.confluenceConnector.execCQL(params, Collections.emptyMap());
            String link = this.confluenceConnector.getURL().split("/wiki")[0];
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("content", content);
            data.put("link", link);
            return data;
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

