/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.projectrak;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.projectrak.functions.PQLExecFunc;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.ProjectrakConnector;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;

public class ProjectrakConnectorServerImpl
implements ProjectrakConnector {
    public static final String APP_SUBPATH = "/rest/projectrak/api/2.0";
    static final String PATH_GET_FIELDS = "/fields";
    static final String PATH_GET_FIELDS_TYPES = "/fields/types";
    static final String PATH_SEARCH_VALIDATION = "/search/validation";
    static final String PATH_GET_VALUE_PROJECT_FIELD = "/values/projects/%s/fields/%s";
    private final ServerConnector connector;
    private final JiraConnector jiraConnector;

    public ProjectrakConnectorServerImpl(ServerConnector connector, JiraConnector jiraConnector) {
        this.connector = connector;
        this.jiraConnector = jiraConnector;
    }

    @Override
    public String getURL() {
        return this.connector.getURL();
    }

    @Override
    public JiraConnector getJiraConnector() {
        return this.jiraConnector;
    }

    @Override
    public boolean isValid() {
        try {
            List<String> someFieldTypes = this.getFieldTypes(false);
            return someFieldTypes != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<Map> getFields(boolean loadAll) {
        ResponseEntity<List> res = this.connector.executeRequest(PATH_GET_FIELDS, null, List.class);
        ResponseChecker.checkStatus(res);
        return (List)res.getBody();
    }

    @Override
    public List<String> getFieldTypes(boolean loadAll) {
        ResponseEntity<List> res = this.connector.executeRequest(PATH_GET_FIELDS_TYPES, null, List.class);
        ResponseChecker.checkStatus(res);
        return (List)res.getBody();
    }

    @Override
    public Map validPQL(String pql) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pql", pql);
        ResponseEntity<Map> res = this.connector.executeRequest(PATH_SEARCH_VALIDATION, params, Map.class);
        ResponseChecker.checkStatus(res);
        return (Map)res.getBody();
    }

    @Override
    public List<Map> loadPQLUsers(List<String> projects) {
        throw new RuntimeException("Method not supported by server connector");
    }

    @Override
    public List<Map> execPQL(String pql, List<Integer> fields, Boolean loadAll) {
        List projects = new PQLExecFunc(this.connector).exec(pql, fields, loadAll);
        return projects;
    }

    @Override
    public Map getField(String projectKey, Integer fieldId) {
        ResponseEntity<Map> res = this.connector.executeRequest(String.format(PATH_GET_VALUE_PROJECT_FIELD, projectKey, fieldId), null, Map.class);
        ResponseChecker.checkStatus(res);
        return (Map)res.getBody();
    }
}

