/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.confluence.cloud;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions.ExecCQLCloudFunc;
import com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions.GetInlineTasksCloudFunc;
import com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions.GetSpacesCloudFunc;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.ConfluenceConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.ImageProvider;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ConfluenceRestCloudConnector
implements ConfluenceConnector,
ImageProvider {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceRestCloudConnector.class);
    public static final String REST_API_USER_CURRENT = "/rest/api/user/current";
    public static final String REST_API_CONTENT_S = "/rest/api/content/%s";
    public static final String REST_API_USER_DETAIL = "/rest/api/user?accountId=%s";
    private ServerConnector connector;

    public ConfluenceRestCloudConnector(ServerConnector connector) {
        this.connector = connector;
    }

    @Override
    public String getURL() {
        return this.connector.getURL();
    }

    @Override
    public boolean isValid() {
        try {
            ResponseEntity<String> response = this.me();
            return response.getStatusCode().value() < 400;
        }
        catch (Exception e) {
            log.error("Problems getting cloud info. URL base: " + this.getURL(), (Throwable)e);
            return false;
        }
    }

    @Override
    public ResponseEntity<List> getSpaces(Map params, Map options) {
        return new GetSpacesCloudFunc(this.connector).getSpaces(params, options);
    }

    @Override
    public List execCQL(Map params, Map<String, Object> options) {
        return new ExecCQLCloudFunc(this.connector).execCQL(params, options);
    }

    @Override
    public List getInlineTasks(Map params, Map options) throws IOException {
        return new GetInlineTasksCloudFunc(this.connector).getData(params);
    }

    @Override
    public List getUsersByUsername(List<String> users) {
        return users.stream().map(username -> {
            String path = String.format(REST_API_USER_DETAIL, username);
            ResponseEntity<Map> responseEntity = this.connector.executeRequest(path, null, Map.class);
            return responseEntity.getStatusCode().value() < 400 ? (Map)responseEntity.getBody() : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public ResponseEntity<String> serverInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResponseEntity<String> me() {
        return this.connector.executeRequest(REST_API_USER_CURRENT);
    }

    @Override
    public Map getContent(Integer contentId) {
        String path = String.format(REST_API_CONTENT_S, contentId);
        ResponseEntity<Map> responseEntity = this.connector.executeRequest(path, null, Map.class);
        ResponseChecker.checkStatus(responseEntity);
        return (Map)responseEntity.getBody();
    }

    @Override
    public List<String> getTaskUsernames(Map task) {
        return GetInlineTasksCloudFunc.getTaskUsernames(task);
    }

    @Override
    public List<Map> formatTasks(List<Map> tasks, List users) {
        List<String> contentIds = GetInlineTasksCloudFunc.getTasksContentIds(tasks);
        Map inlineUsersTaskMap = GetInlineTasksCloudFunc.getInlineUsersTaskMap(tasks);
        List<Map> contents = contentIds.stream().map(contentId -> {
            Map content = this.getContent(Integer.valueOf(contentId));
            LinkedHashMap<String, Integer> newContent = new LinkedHashMap<String, Integer>();
            newContent.put("id", Integer.valueOf((String)content.get("id")));
            newContent.put("title", (Integer)content.get("title"));
            return newContent;
        }).collect(Collectors.toList());
        LinkedHashMap userMap = new LinkedHashMap();
        users.stream().forEach(user -> userMap.put(((Map)user).get("accountId"), user));
        return GetInlineTasksCloudFunc.formatTasks(tasks, inlineUsersTaskMap, userMap, contents);
    }

    @Override
    public ResponseEntity<InputStream> getImage(String path) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "*/*".toString());
        headers.put("encoding", "binary");
        ResponseEntity<InputStream> response = this.connector.executeRequest(Request.MethodType.GET, path, null, headers, InputStream.class);
        return response;
    }
}

