/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.jira.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import com.roninpixels.dashboardhub.web.rest.jira.api.SearchReportersRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/jira/v1/reporter")
public class ReportersEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ReportersEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;
    @Inject
    private DHUserService dhUserService;

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/search")
    public Response search(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @NotNull SearchReportersRequest request) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            List<Map> suggestions = this.getSuggestions(jira, request);
            List userNames = suggestions.stream().map(suggestion -> (String)suggestion.get("value")).filter(key -> request.getExcludeAccountIds() == null || !request.getExcludeAccountIds().contains(key)).collect(Collectors.toList());
            List users = userNames.parallelStream().map(name -> {
                AppUser user = this.dhUserService.getUserByName((String)name, true);
                if (user == null) {
                    return null;
                }
                HashMap<String, Object> userData = new HashMap<String, Object>();
                userData.put("name", name);
                userData.put("accountId", user.getKey());
                userData.put("accountType", user.getAccountType());
                userData.put("displayName", user.getDisplayName());
                HashMap<String, String> avatarUrls = new HashMap<String, String>();
                avatarUrls.put("16x16", user.getAvatarUrl());
                userData.put("avatarUrls", avatarUrls);
                userData.put("avatarUrl", user.getAvatarUrl());
                return userData;
            }).filter(userData -> userData != null).collect(Collectors.toList());
            Map usersByName = users.stream().collect(HashMap::new, (map, user) -> map.put((String)user.get("name"), user), HashMap::putAll);
            List searchResult = suggestions.stream().map(suggestion -> {
                String key = (String)suggestion.get("value");
                if (usersByName.containsKey(key)) {
                    return (Map)usersByName.get(key);
                }
                HashMap defaultExc = new HashMap();
                HashMap<String, Boolean> defaultValue = new HashMap<String, Boolean>();
                defaultValue.put("excluded", true);
                defaultExc.put(key, defaultValue);
                return defaultExc;
            }).collect(Collectors.toList());
            return Response.status((int)200).entity(searchResult).build();
        }
        catch (Exception e) {
            log.error("Problems getting reporters suggestions", (Throwable)e);
            return Response.status((int)400).build();
        }
    }

    List<Map> getSuggestions(JiraConnector jira, SearchReportersRequest request) {
        String fieldValue = request.getSearchTerm();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fieldName", "reporter");
        params.put("fieldValue", fieldValue == null ? "" : fieldValue);
        ResponseEntity<List> response = jira.getJqlSuggestions(params);
        ResponseChecker.checkStatus(response);
        List suggestions = (List)response.getBody();
        return suggestions;
    }
}

