/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.jira.api;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.http.ResponseEntity;

public class GenericJiraEndpoint {
    public static Response generateResponse(ResponseEntity<?> res) {
        try {
            return GenericJiraEndpoint.generateResponse(res, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Response generateResponse(ResponseEntity<?> res, String rootName) throws IOException {
        int value = res.getStatusCode().value();
        if (value >= 400) {
            Response.ResponseBuilder builder = Response.status((int)value);
            if (res.getBody() != null) {
                builder.entity(res.getBody());
            }
            return builder.build();
        }
        HashMap<String, Object> responseEntity = res.getBody();
        if (rootName != null) {
            HashMap<String, Object> newValue = new HashMap<String, Object>();
            if (responseEntity instanceof String) {
                ObjectMapper mapper = new ObjectMapper();
                List fields = (List)mapper.readValue(res.getBody().toString(), List.class);
                newValue.put(rootName, fields);
            } else {
                newValue.put(rootName, responseEntity);
            }
            responseEntity = newValue;
        }
        return Response.status((int)res.getStatusCode().value()).entity((Object)responseEntity).build();
    }

    public static Response generateResponse(BadRequestToSourceException bre) {
        ResponseEntity sourceResponse = bre.getResponseEntity();
        Object entity = sourceResponse != null ? sourceResponse.getBody() : bre.getBody();
        return Response.status((int)bre.getStatusCode()).entity(entity).build();
    }
}

