/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.bitbucket.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.BitbucketConnector;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.globals.Product;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/bitbucket/v1/workspaces")
public class WorkspacesEndpoint {
    private static final Logger log = LoggerFactory.getLogger(WorkspacesEndpoint.class);
    @Inject
    private ConnectorsFactory connectorsFactory;
    @Inject
    private DatasourcesUtil dsUtil;

    DatasourceModel generateTemporalDatasource(String url, String username, String password) {
        DatasourceModel ds = new DatasourceModel();
        ds.setName("bitbucket temporal");
        ds.setUrl(url);
        ds.setProduct(Product.BITBUCKET.value());
        DsOptionsModel dsOptions = new DsOptionsModel();
        dsOptions.addOtherConfig("hostType", "cloud");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("username", username);
        options.put("password", password);
        dsOptions.addOtherConfig("options", options);
        ds.setOptions(dsOptions);
        return this.dsUtil.generateTemporal(ds, dsOptions);
    }

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response searchWorkspaces(@NotNull @QueryParam(value="url") String url, @NotNull @QueryParam(value="username") String username, @NotNull @QueryParam(value="password") String password) {
        try {
            DatasourceModel ds = this.generateTemporalDatasource(url, username, password);
            BitbucketConnector connector = (BitbucketConnector)this.connectorsFactory.getConnector(ds);
            ResponseEntity<List> sourceResponse = connector.getWorkspaces(Collections.emptyMap(), true);
            int status = sourceResponse.getStatusCodeValue();
            if (status < 400) {
                return Response.status((int)status).entity(sourceResponse.getBody()).build();
            }
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            log.error("Problems searching Bitbucket workspaces at -> " + url, (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

