/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.common.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class getGroupUsersFunc {
    private static final Logger log = LoggerFactory.getLogger(getGroupUsersFunc.class);
    static String PATH_PATTERN = "/rest/api/2/group/member";
    private final ServerConnector connector;

    public getGroupUsersFunc(ServerConnector jiraServerConnector) {
        this.connector = jiraServerConnector;
    }

    public ResponseEntity<List> execute(String groupName, Map<String, ?> params, Map<String, Object> paginationOptions) {
        if (groupName == null || groupName.trim().equals("")) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        boolean loadAll = paginationOptions == null || (Boolean)paginationOptions.getOrDefault("all", true) != false;
        String path = String.format(PATH_PATTERN, groupName);
        HashMap<String, Object> mParams = params == null ? new HashMap<String, Object>() : new HashMap(params);
        mParams.putIfAbsent("groupname", groupName);
        mParams.putIfAbsent("startAt", 0);
        boolean moreData = true;
        LinkedList users = new LinkedList();
        do {
            ResponseEntity<Map> response;
            if ((response = this.connector.executeRequest(path, mParams, Map.class)).getStatusCode().value() >= 400) {
                return new ResponseEntity(response.getStatusCode());
            }
            Map responseData = (Map)response.getBody();
            users.addAll((List)responseData.get("values"));
            Boolean isLast = (Boolean)responseData.get("isLast");
            if (isLast != Boolean.TRUE && loadAll && users.size() < 1000) {
                int next = (Integer)responseData.get("startAt") + (Integer)responseData.get("maxResults");
                mParams.put("startAt", next);
                continue;
            }
            moreData = false;
        } while (moreData);
        return new ResponseEntity(users, HttpStatus.OK);
    }
}

