/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.authStrategy.strategies;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.web.util.UriComponentsBuilder;

public class DatasourceOAuthStrategy
implements RestAuthStrategy {
    private final String P_API_TOKEN = "apiToken";
    private final DatasourceModel datasource;
    private final ObjectMapper mapper;
    @Inject
    private Crypto mCrypto;

    public DatasourceOAuthStrategy(DatasourceModel datasource) {
        this.datasource = datasource;
        this.mapper = new ObjectMapper();
    }

    @Override
    public Request applyAuthenticationStrategy(Request request, UriComponentsBuilder builder) {
        String apiToken;
        DsOptionsModel dsOptions = this.getOptions(this.datasource.getToken());
        Map options = dsOptions.getOption("options", Map.class);
        String string = apiToken = options != null ? (String)options.get("apiToken") : null;
        if (apiToken != null) {
            String authValue = String.format("Oauth %s", apiToken);
            return request.addHeader("Authorization", authValue);
        }
        throw new RuntimeException("API Token not defined");
    }

    @Override
    public void analyzeHeaders(Response response) {
    }

    private DsOptionsModel getOptions(String token) {
        try {
            return (DsOptionsModel)this.mapper.readValue(this.mCrypto.decryptBackend(token), DsOptionsModel.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

