/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.macro;

import com.atlassian.confluence.content.render.image.ImageDimensions;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.roninpixels.dashboardhub.confluence.macro.ImagePlaceHolderProvider;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class ImagePlaceholderProviderV1
implements ImagePlaceHolderProvider {
    static final int IMAGE_WIDTH = 1056;
    static final int IMAGE_HEIGHT = 562;
    private static final String IMAGES_FOLDER_PATH = "/download/resources/com.roninpixels.dashboards.confluence:dh-react-app/app/app/assets/images/dashboards";
    private static final String IMAGE_NAME = "empty-white.svg";
    @Inject
    @ConfluenceImport
    private SettingsManager settingsManager;

    @Override
    public ImagePlaceholder getImagePlaceholder(Map<String, String> map, ConversionContext conversionContext) {
        int actualWidth = this.getIntegerValue(map.get("width"), 1056);
        int actualHeight = this.getIntegerValue(map.get("height"), 562);
        String imagePath = String.format("%s/%s/%s", this.settingsManager.getGlobalSettings().getBaseUrl(), IMAGES_FOLDER_PATH, IMAGE_NAME);
        ImageDimensions dimensions = new ImageDimensions(actualWidth, actualHeight);
        return new DefaultImagePlaceholder(imagePath, false, dimensions);
    }

    private int getIntegerValue(String value, int defaultValue) {
        try {
            if (value == null) {
                return defaultValue;
            }
            if (value.trim().endsWith("%")) {
                int percent = Integer.parseInt(value.replaceAll("%", ""));
                return defaultValue * percent / 100;
            }
            return (int)Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }
}

