/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.jira.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.ImmutableMap;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import com.roninpixels.dashboardhub.web.rest.jira.api.JQLEndpoint;
import com.roninpixels.dashboardhub.web.rest.jira.api.SearchEpicsRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/jira/v1/searchEpics")
public class SearchEpicsEndpoint {
    private static final Logger log = LoggerFactory.getLogger(JQLEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    List<Map> getSuggestions(JiraConnector jira, SearchEpicsRequest request) {
        String fieldName = request.getEpicLinkFieldClauseName();
        String fieldValue = request.getSearchTerm();
        if (fieldName == null || fieldName.isEmpty()) {
            throw new RuntimeException("Field name for suggestions cannot be null - " + fieldName);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fieldName", fieldName);
        params.put("fieldValue", fieldValue == null ? "" : fieldValue);
        ResponseEntity<List> response = jira.getJqlSuggestions(params);
        ResponseChecker.checkStatus(response);
        List suggestions = (List)response.getBody();
        return suggestions;
    }

    List<Map> getEpics(JiraConnector jira, SearchEpicsRequest request, List<Map> suggestions) {
        List epicKeys = suggestions.stream().map(suggestion -> (String)suggestion.get("value")).filter(epicKey -> !request.getExcludeEpicKeys().contains(epicKey)).collect(Collectors.toList());
        List issues = Collections.emptyList();
        if (!epicKeys.isEmpty()) {
            String jql = String.format("key in (%s)", epicKeys.stream().collect(Collectors.joining(",")));
            issues = jira.execJQL(jql, request.getEpicFieldKeys(), null, null, null, null);
        }
        List excludedIssues = suggestions.stream().map(suggestion -> (String)suggestion.get("value")).filter(epicKey -> request.getExcludeEpicKeys().contains(epicKey)).map(epicKey -> ImmutableMap.of((Object)"key", (Object)epicKey, (Object)"excluded", (Object)true)).collect(Collectors.toList());
        return Stream.concat(issues.stream(), excludedIssues.stream()).collect(Collectors.toList());
    }

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response search(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @NotNull SearchEpicsRequest request) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            List<Map> suggestions = this.getSuggestions(jira, request);
            List epics = suggestions.isEmpty() ? Collections.emptyList() : this.getEpics(jira, request, suggestions);
            return Response.status((int)200).entity(epics).build();
        }
        catch (Exception e) {
            log.error("Problems getting epics suggestions", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

