/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.store.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.roninpixels.dashboardhub.ao.DHUserPreference;
import com.roninpixels.dashboardhub.store.DHUserPreferencesRepository;
import com.roninpixels.dashboardhub.web.models.UserPreferencesModel;
import java.io.IOException;
import java.util.Date;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DHUserPreferencesRepositoryImpl
implements DHUserPreferencesRepository {
    private static final Logger log = LoggerFactory.getLogger(DHUserPreferencesRepositoryImpl.class);
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private final ObjectMapper mMapper;

    @Inject
    public DHUserPreferencesRepositoryImpl(ActiveObjects ao, TransactionTemplate transactionTemplate) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
        this.mMapper = new ObjectMapper();
    }

    @Override
    public UserPreferencesModel getUserPreference(String userKey) {
        DHUserPreference data = this.findUserPreference(userKey);
        return this.txDHUserPreference(data);
    }

    @Override
    public UserPreferencesModel addUserPreference(String userKey, UserPreferencesModel preferences) throws IOException {
        String serializedPrefs = this.mMapper.writeValueAsString((Object)preferences);
        DHUserPreference savedUserPreference = (DHUserPreference)this.transactionTemplate.execute(() -> {
            DHUserPreference userPreference = this.createUserPreference(userKey, serializedPrefs);
            log.debug("UserPreference created -> " + userPreference.getUserKey());
            return userPreference;
        });
        return this.txDHUserPreference(savedUserPreference);
    }

    @Override
    public UserPreferencesModel updateUserPreference(String userKey, UserPreferencesModel preferences) throws IOException {
        String serializedPrefs = this.mMapper.writeValueAsString((Object)preferences);
        DHUserPreference updatedUserPreference = (DHUserPreference)this.transactionTemplate.execute(() -> {
            DHUserPreference target = this.findUserPreference(userKey);
            if (target == null) {
                target = this.createUserPreference(userKey, serializedPrefs);
                log.debug("UserPreference created -> " + target.getUserKey());
            } else if (target != null) {
                target.setPreferences(serializedPrefs);
                target.setUpdated(new Date());
                target.save();
                log.debug("UserPreference updated -> " + userKey);
            }
            return target;
        });
        return this.txDHUserPreference(updatedUserPreference);
    }

    @Override
    public int removeUserPreference(String userKey) {
        DHUserPreference userPrefs = (DHUserPreference)this.transactionTemplate.execute(() -> {
            DHUserPreference target = this.findUserPreference(userKey);
            if (target != null) {
                this.ao.delete(new RawEntity[]{target});
            }
            return target;
        });
        return userPrefs == null ? 0 : 1;
    }

    private DHUserPreference findUserPreference(String userKey) {
        Query query = Query.select().where("USER_KEY = ?", new Object[]{userKey});
        DHUserPreference[] userPreferences = (DHUserPreference[])this.ao.find(DHUserPreference.class, query);
        if (userPreferences.length == 0) {
            return null;
        }
        if (userPreferences.length > 1) {
            throw new RuntimeException(String.format("There are more than one userPreference with same userKey: %s", userKey));
        }
        return userPreferences[0];
    }

    private DHUserPreference createUserPreference(String userKey, String serializedPrefs) {
        DHUserPreference userPreference = (DHUserPreference)this.ao.create(DHUserPreference.class, new DBParam[]{new DBParam("USER_KEY", (Object)userKey), new DBParam("CREATED", (Object)new Date()), new DBParam("UPDATED", (Object)new Date()), new DBParam("PREFERENCES", (Object)serializedPrefs)});
        userPreference.save();
        return userPreference;
    }

    private UserPreferencesModel txDHUserPreference(DHUserPreference userPreference) {
        if (userPreference == null) {
            return null;
        }
        try {
            return (UserPreferencesModel)this.mMapper.readValue(userPreference.getPreferences(), UserPreferencesModel.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

