/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.TimePeriodOption;
import java.util.Date;
import org.joda.time.DateTime;

public class TimePeriodUtil {
    public static boolean matchOptionTimePeriod(TimePeriodOption option, String releasedDate) {
        DateTime releasedDT = DateTime.parse((String)releasedDate);
        return TimePeriodUtil.matchOptionTimePeriod(option, releasedDT);
    }

    public static boolean matchOptionTimePeriod(TimePeriodOption option, Date releasedDate) {
        return TimePeriodUtil.matchOptionTimePeriod(option, new DateTime((Object)releasedDate));
    }

    public static boolean matchOptionTimePeriod(TimePeriodOption option, DateTime releasedDT) {
        long releasedMillis = releasedDT.getMillis();
        switch (option) {
            case TODAY: {
                return releasedDT.withTimeAtStartOfDay().getMillis() == DateTime.now().withTimeAtStartOfDay().getMillis();
            }
            case LAST_7_DAYS: {
                return releasedMillis >= DateTime.now().minusDays(7).withTimeAtStartOfDay().getMillis();
            }
            case LAST_14_DAYS: {
                return releasedMillis >= DateTime.now().minusDays(14).withTimeAtStartOfDay().getMillis();
            }
            case LAST_MONTH: {
                DateTime lastMonthPivot = DateTime.now().minusMonths(1);
                return lastMonthPivot.getYear() == releasedDT.getYear() && lastMonthPivot.getMonthOfYear() == releasedDT.getMonthOfYear();
            }
            case CURRENT_MONTH: {
                DateTime currentMonthPivot = DateTime.now();
                return currentMonthPivot.getYear() == releasedDT.getYear() && currentMonthPivot.getMonthOfYear() == releasedDT.getMonthOfYear();
            }
            case LAST_QUARTER: {
                DateTime[] lastQuarter = TimePeriodUtil.getQuarter(DateTime.now().minusMonths(3));
                long firstDayPreviousQuarter = lastQuarter[0].getMillis();
                long lastDayPreviousQuarter = lastQuarter[1].getMillis();
                return firstDayPreviousQuarter <= releasedMillis && releasedMillis <= lastDayPreviousQuarter;
            }
            case CURRENT_QUARTER: {
                DateTime[] currentQuarter = TimePeriodUtil.getQuarter(DateTime.now());
                long firstDayCurrentQuarter = currentQuarter[0].getMillis();
                long lastDayCurrentQuarter = currentQuarter[1].getMillis();
                return firstDayCurrentQuarter <= releasedMillis && releasedMillis <= lastDayCurrentQuarter;
            }
            case LAST_YEAR: {
                return releasedDT.getYear() == DateTime.now().minusYears(1).getYear();
            }
            case CURRENT_YEAR: {
                return releasedDT.getYear() == DateTime.now().getYear();
            }
        }
        return false;
    }

    private static DateTime[] getQuarter(DateTime pivotDT) {
        DateTime[] quarter = new DateTime[2];
        int quarterNumber = (pivotDT.getMonthOfYear() - 1) / 3;
        quarter[0] = pivotDT.withMonthOfYear(quarterNumber * 3 + 1).dayOfMonth().withMinimumValue().withTimeAtStartOfDay();
        quarter[1] = quarter[0].plusMonths(3).dayOfMonth().withMinimumValue().withTimeAtStartOfDay().minusMillis(1);
        return quarter;
    }
}

