/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JiraDataUtils {
    private static final Logger log = LoggerFactory.getLogger(JiraDataUtils.class);

    public static final boolean matchField(String fieldId, Field field) {
        return fieldId.equals(field.getId()) || fieldId.equals(field.getKey()) || fieldId.equals(field.getName()) || fieldId.equals(field.getUntranslatedName());
    }

    public static final List<Field> getFieldsWithSameName(String fieldId, List<Field> fieldList) {
        Field field = fieldList.stream().filter(f -> JiraDataUtils.matchField(fieldId, f)).findFirst().orElse(null);
        if (field == null) {
            return null;
        }
        String fieldName = Stream.of(field.getId(), field.getKey(), field.getName(), field.getUntranslatedName()).filter(name -> name != null).findFirst().get();
        List<Field> matches = fieldList.stream().filter(f -> JiraDataUtils.matchField(fieldName, f)).collect(Collectors.toList());
        return matches;
    }

    public static final Map getActiveSprint(Long boardId, List<Map> sprints) {
        return sprints.stream().filter(sprint -> {
            String state = (String)sprint.get("state");
            if (sprint.get("originBoardId") == null) {
                return false;
            }
            long originBoardId = ((Number)sprint.get("originBoardId")).longValue();
            return "active".equals(state) && originBoardId == boardId;
        }).findFirst().orElse(null);
    }

    public static final List<Map> removeDuplicate(List<Map> entities) {
        HashSet ids = new HashSet();
        return entities.stream().filter(entity -> {
            Object key = entity.get("id");
            return ids.add(key);
        }).collect(Collectors.toList());
    }
}

