/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.cloud.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class GetAllFiltersCloudFunc {
    private static final Logger log = LoggerFactory.getLogger(GetAllFiltersCloudFunc.class);
    static final String PATH_FAV_FILTERS = "/rest/api/2/filter/favourite";
    static final String PATH_GREENHOPPER_FILTERS = "/rest/api/2/filter/search";
    static final int MAX_FILTERS_CLOUD = 1000;
    private final ServerConnector connector;

    public GetAllFiltersCloudFunc(ServerConnector connector) {
        this.connector = connector;
    }

    public ResponseEntity<List> getAllFilters(Map<String, ?> params, Map<String, Object> options) {
        if (options.get("favouritesOnly") != null && options.get("favouritesOnly").equals("true")) {
            List<Map> favourites = this.getFavouriteFilters();
            return new ResponseEntity(favourites, HttpStatus.OK);
        }
        HashMap<String, Integer> mParams = params == null ? new HashMap<String, Integer>() : new HashMap(params);
        mParams.putIfAbsent("startAt", 0);
        mParams.putIfAbsent("maxResults", 200);
        boolean moreData = true;
        LinkedList filters = new LinkedList();
        do {
            ResponseEntity<Map> response;
            if ((response = this.connector.executeRequest(PATH_GREENHOPPER_FILTERS, mParams, Map.class)).getStatusCode().value() >= 400) {
                return new ResponseEntity(response.getStatusCode());
            }
            Map responseData = (Map)response.getBody();
            filters.addAll((List)responseData.get("values"));
            Boolean isLast = (Boolean)responseData.get("isLast");
            int next = (Integer)responseData.get("startAt") + (Integer)responseData.get("maxResults");
            if (isLast != Boolean.TRUE && next < 1000) {
                mParams.put("startAt", next);
                continue;
            }
            moreData = false;
        } while (moreData);
        return new ResponseEntity(filters, HttpStatus.OK);
    }

    List<Map> getFavouriteFilters() {
        ResponseEntity<List> response = this.connector.executeRequest(PATH_FAV_FILTERS, null, List.class);
        ResponseChecker.checkStatus(response);
        List filters = (List)response.getBody();
        return filters.stream().map(this::txFilter).collect(Collectors.toList());
    }

    Map txFilter(Map rawFilter) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String id = rawFilter.get("id").toString();
        data.put("id", id);
        data.put("favourite", rawFilter.getOrDefault("favourite", false));
        data.put("name", rawFilter.get("name"));
        if (rawFilter.containsKey("jql")) {
            data.put("jql", rawFilter.get("jql"));
        } else {
            data.put("jql", rawFilter.get("query"));
        }
        if (data.containsKey("self")) {
            data.put("self", rawFilter.get("self"));
        } else {
            data.put("self", String.format("%s/rest/api/2/filter/%s", this.connector.getURL(), id));
        }
        return data;
    }
}

