/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.confluence.common.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ExecCQLFunc {
    private static final Logger log = LoggerFactory.getLogger(ExecCQLFunc.class);
    private final ServerConnector connector;
    private String path;

    public ExecCQLFunc(ServerConnector connector, String path) {
        this.connector = connector;
        this.path = path;
    }

    private String getURLNext(Map response) {
        try {
            if (!response.containsKey("_links")) {
                return null;
            }
            Map links = (Map)response.get("_links");
            String urlNext = (String)links.get("next");
            return urlNext == null ? null : URLDecoder.decode(urlNext, StandardCharsets.UTF_8.name());
        }
        catch (IOException ioe) {
            log.warn("Problems decoding an URL", (Throwable)ioe);
            return null;
        }
    }

    public List execCQL(Map params, Map<String, Object> options) {
        boolean all = (Boolean)options.getOrDefault("all", true);
        int start = params.getOrDefault("start", 0);
        int limit = params.getOrDefault("limit", 300);
        HashMap<String, Object> mParams = new HashMap<String, Object>(params);
        mParams.put("start", start);
        mParams.put("limit", limit);
        if (options.containsKey("expand")) {
            mParams.put("expand", options.get("expand"));
        }
        String url = this.path;
        try {
            boolean moreData;
            LinkedList data = new LinkedList();
            do {
                ResponseEntity<Map> response = this.connector.executeRequest(url, mParams, Map.class);
                ResponseChecker.checkStatus(response);
                Map result = (Map)response.getBody();
                List currentData = (List)result.get("results");
                data.addAll(currentData);
                String nextURL = this.getURLNext(result);
                int nextCount = limit + data.size();
                boolean bl = moreData = all && nextCount < 1000 && nextURL != null;
                if (!moreData) continue;
                mParams.put("start", start += limit);
                url = nextURL;
            } while (moreData);
            return data;
        }
        catch (BadRequestToSourceException bre) {
            throw bre;
        }
        catch (Exception ex) {
            log.error("Bad data", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

